/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.selection;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.jarjar.metadata.ContainedJarMetadata;
import net.minecraftforge.jarjar.metadata.Metadata;
import net.minecraftforge.jarjar.metadata.MetadataIOHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarSelector.class);

    private JarSelector() {
        throw new IllegalStateException("Can not instantiate an instance of: JarSelector. This is a utility class");
    }

    public static <T> List<T> detectAndSelect(List<T> source, BiFunction<T, Path, Optional<InputStream>> resourceReader, BiFunction<T, Path, Optional<T>> sourceProducer, Function<T, String> identificationProducer) {
        Map detectedJarsBySource = JarSelector.detect(source, resourceReader, sourceProducer, identificationProducer);
        Set<ContainedJarMetadata> select = JarSelector.select(detectedJarsBySource.keySet());
        return select.stream().filter(detectedJarsBySource::containsKey).map(selectedJarMetadata -> {
            Object sourceOfJar = detectedJarsBySource.get(selectedJarMetadata);
            return (Optional)sourceProducer.apply(sourceOfJar, Path.of(selectedJarMetadata.path(), new String[0]));
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static <T> Map<ContainedJarMetadata, T> detect(List<T> source, BiFunction<T, Path, Optional<InputStream>> resourceReader, BiFunction<T, Path, Optional<T>> sourceProducer, Function<T, String> identificationProducer) {
        Path metadataPath = Path.of("META-INF/jarjar/metadata.json", new String[0]);
        Map metadataInputStreamsBySource = source.stream().collect(Collectors.toMap(Function.identity(), t -> (Optional)resourceReader.apply(t, metadataPath)));
        record SourceWithOptionalMetadata<Z>(Z source, Optional<Metadata> metadata) {
        }
        Map<Object, Metadata> metadataBySource = metadataInputStreamsBySource.entrySet().stream().filter(kvp -> ((Optional)kvp.getValue()).isPresent()).map(kvp -> new SourceWithOptionalMetadata(kvp.getKey(), MetadataIOHandler.fromStream((InputStream)((Optional)kvp.getValue()).get()))).filter(sourceWithOptionalMetadata -> sourceWithOptionalMetadata.metadata().isPresent()).collect(Collectors.toMap(SourceWithOptionalMetadata::source, sourceWithOptionalMetadata -> sourceWithOptionalMetadata.metadata().get()));
        Multimap<Object, ContainedJarMetadata> containedJarMetadatasBySource = JarSelector.recursivelyDetectContainedJars(metadataBySource, resourceReader, sourceProducer, identificationProducer);
        return containedJarMetadatasBySource.entries().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    private static <T> Multimap<T, ContainedJarMetadata> recursivelyDetectContainedJars(Map<T, Metadata> metadataBySource, BiFunction<T, Path, Optional<InputStream>> resourceReader, BiFunction<T, Path, Optional<T>> sourceProducer, Function<T, String> identificationProducer) {
        HashMultimap containedJarMetadatasBySource = HashMultimap.create();
        LinkedList<T> sourcesToProcess = new LinkedList<T>();
        for (Map.Entry<T, Metadata> entry : metadataBySource.entrySet()) {
            containedJarMetadatasBySource.putAll(entry.getKey(), entry.getValue().jars());
            for (ContainedJarMetadata jar : entry.getValue().jars()) {
                Optional<T> source = sourceProducer.apply(entry.getKey(), Path.of(jar.path(), new String[0]));
                if (source.isPresent()) {
                    sourcesToProcess.add(source.get());
                    continue;
                }
                LOGGER.warn("The source jar: " + identificationProducer.apply(entry.getKey()) + " is supposed to contain a jar: " + jar.path() + " but it does not exist.");
            }
        }
        while (!sourcesToProcess.isEmpty()) {
            Object source = sourcesToProcess.remove();
            Optional<InputStream> metadataInputStream = resourceReader.apply(source, Path.of("META-INF/jarjar/metadata.json", new String[0]));
            if (metadataInputStream.isPresent()) {
                Optional<Metadata> metadata = MetadataIOHandler.fromStream(metadataInputStream.get());
                if (!metadata.isPresent()) continue;
                containedJarMetadatasBySource.putAll(source, metadata.get().jars());
                for (ContainedJarMetadata jar : metadata.get().jars()) {
                    Optional<T> sourceJar = sourceProducer.apply(source, Path.of(jar.path(), new String[0]));
                    if (sourceJar.isPresent()) {
                        sourcesToProcess.add(sourceJar.get());
                        continue;
                    }
                    LOGGER.warn("The source jar: " + identificationProducer.apply(source) + " is supposed to contain a jar: " + jar.path() + " but it does not exist.");
                }
                continue;
            }
            LOGGER.warn("The source jar: " + identificationProducer.apply(source) + " is supposed to contain a contained jars metadata but it does not exist.");
        }
        return containedJarMetadatasBySource;
    }

    private static Set<ContainedJarMetadata> select(Set<ContainedJarMetadata> containedJarMetadata) {
        Multimap jarsByIdentifier = (Multimap)containedJarMetadata.stream().collect(Multimaps.toMultimap(ContainedJarMetadata::identifier, Function.identity(), HashMultimap::create));
        return jarsByIdentifier.keySet().stream().map(arg_0 -> ((Multimap)jarsByIdentifier).get(arg_0)).flatMap(jars -> {
            if (jars.size() <= 1) {
                return jars.stream();
            }
            VersionRange range = jars.stream().map(ContainedJarMetadata::version).reduce(null, JarSelector::restrictRanges);
            if (range == null) {
                return Stream.empty();
            }
            if (!JarSelector.isValid(range)) {
                return Stream.empty();
            }
            if (range.getRecommendedVersion() != null) {
                return jars.stream().filter(jar -> jar.version().getRecommendedVersion().equals(range.getRecommendedVersion())).findFirst().stream();
            }
            return jars.stream().filter(jar -> range.containsVersion(jar.version().getRecommendedVersion())).findFirst().stream();
        }).collect(Collectors.toSet());
    }

    private static VersionRange restrictRanges(VersionRange versionRange, VersionRange versionRange2) {
        if (versionRange == null) {
            return versionRange2;
        }
        if (versionRange2 == null) {
            return versionRange;
        }
        return versionRange.restrict(versionRange);
    }

    private static boolean isValid(VersionRange range) {
        return range.getRecommendedVersion() == null && !range.hasRestrictions();
    }
}

