/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.metadata.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraftforge.jarjar.metadata.ContainedJarIdentifier;
import net.minecraftforge.jarjar.metadata.ContainedJarMetadata;
import org.apache.maven.artifact.versioning.VersionRange;

public class ContainedJarMetadataSerializer
implements JsonSerializer<ContainedJarMetadata>,
JsonDeserializer<ContainedJarMetadata> {
    public ContainedJarMetadata deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expected object");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        ContainedJarIdentifier containedJarIdentifier = (ContainedJarIdentifier)context.deserialize(jsonObject.get("identifier"), ContainedJarIdentifier.class);
        VersionRange range = (VersionRange)context.deserialize(jsonObject.get("version"), VersionRange.class);
        String path = jsonObject.get("path").getAsString();
        return new ContainedJarMetadata(containedJarIdentifier, range, path);
    }

    public JsonElement serialize(ContainedJarMetadata src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("identifier", context.serialize((Object)src.identifier()));
        jsonObject.add("range", context.serialize((Object)src.version()));
        jsonObject.add("path", (JsonElement)new JsonPrimitive(src.path()));
        return jsonObject;
    }
}

