/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.metadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import net.minecraftforge.jarjar.metadata.ContainedJarIdentifier;
import net.minecraftforge.jarjar.metadata.ContainedJarMetadata;
import net.minecraftforge.jarjar.metadata.Metadata;
import net.minecraftforge.jarjar.metadata.json.ArtifactVersionSerializer;
import net.minecraftforge.jarjar.metadata.json.ContainedJarIdentifierSerializer;
import net.minecraftforge.jarjar.metadata.json.ContainedJarMetadataSerializer;
import net.minecraftforge.jarjar.metadata.json.MetadataSerializer;
import net.minecraftforge.jarjar.metadata.json.VersionRangeSerializer;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataIOHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataIOHandler.class);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(VersionRange.class, (Object)new VersionRangeSerializer()).registerTypeAdapter(ArtifactVersion.class, (Object)new ArtifactVersionSerializer()).registerTypeAdapter(ContainedJarIdentifier.class, (Object)new ContainedJarIdentifierSerializer()).registerTypeAdapter(ContainedJarMetadata.class, (Object)new ContainedJarMetadataSerializer()).registerTypeAdapter(Metadata.class, (Object)new MetadataSerializer()).setPrettyPrinting().create();

    private MetadataIOHandler() {
        throw new IllegalStateException("Can not instantiate an instance of: MetadataIOHandler. This is a utility class");
    }

    public static Optional<Metadata> fromStream(InputStream stream) {
        try {
            return Optional.of((Metadata)GSON.fromJson((Reader)new InputStreamReader(stream), Metadata.class));
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse metadata", (Throwable)e);
            return Optional.empty();
        }
    }
}

