/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarcompatibilitychecker.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.jarcompatibilitychecker.data.AnnotationInfo;
import net.minecraftforge.jarcompatibilitychecker.data.FieldInfo;
import net.minecraftforge.jarcompatibilitychecker.data.MemberInfo;
import net.minecraftforge.jarcompatibilitychecker.data.MethodInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassInfo
implements MemberInfo {
    public final String name;
    public final int access;
    public final String superName;
    public final List<AnnotationInfo> annotations;
    private final List<String> interfaces;
    private final Map<String, MethodInfo> methods;
    private final Map<String, FieldInfo> fields;

    private static Map<String, MethodInfo> makeMap(List<MethodInfo> lst) {
        if (lst.isEmpty()) {
            return null;
        }
        HashMap<String, MethodInfo> ret = new HashMap<String, MethodInfo>();
        lst.forEach(info -> ret.put(info.name + " " + info.desc, (MethodInfo)info));
        return ret;
    }

    public ClassInfo(ClassNode node) {
        this.name = node.name;
        this.access = node.access;
        this.annotations = AnnotationInfo.create(node.visibleAnnotations, node.invisibleAnnotations);
        this.superName = node.superName;
        this.interfaces = node.interfaces.isEmpty() ? null : node.interfaces;
        ArrayList<MethodInfo> lst = new ArrayList<MethodInfo>();
        if (!node.methods.isEmpty()) {
            node.methods.forEach(mn -> lst.add(new MethodInfo(this, (MethodNode)mn)));
        }
        this.methods = ClassInfo.makeMap(lst);
        this.fields = !node.fields.isEmpty() ? node.fields.stream().map(FieldInfo::new).collect(Collectors.toMap(e -> e.name, e -> e)) : null;
    }

    public ClassInfo(Class<?> clazz) {
        this.name = clazz.getName().replace('.', '/');
        this.access = clazz.getModifiers();
        this.annotations = ImmutableList.of();
        this.superName = clazz.getSuperclass() == null ? null : clazz.getSuperclass().getName().replace('.', '/');
        ArrayList<String> intfs = new ArrayList<String>();
        for (Class<?> i : clazz.getInterfaces()) {
            intfs.add(i.getName().replace('.', '/'));
        }
        this.interfaces = intfs.isEmpty() ? null : intfs;
        ArrayList<MethodInfo> mtds = new ArrayList<MethodInfo>();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            mtds.add(new MethodInfo(this, constructor));
        }
        for (Executable executable : clazz.getDeclaredMethods()) {
            mtds.add(new MethodInfo(this, (Method)executable));
        }
        this.methods = ClassInfo.makeMap(mtds);
        Field[] flds = clazz.getDeclaredFields();
        this.fields = flds.length > 0 ? Arrays.stream(flds).map(FieldInfo::new).collect(Collectors.toMap(e -> e.name, e -> e)) : null;
    }

    @NotNull
    public List<String> getInterfaces() {
        return this.interfaces == null ? ImmutableList.of() : this.interfaces;
    }

    @NotNull
    public Map<String, MethodInfo> getMethods() {
        return this.methods == null ? ImmutableMap.of() : this.methods;
    }

    @Nullable
    public MethodInfo getMethod(String name, String desc) {
        return this.methods == null ? null : this.methods.get(name + " " + desc);
    }

    @NotNull
    public Map<String, FieldInfo> getFields() {
        return this.fields == null ? ImmutableMap.of() : this.fields;
    }

    @Nullable
    public FieldInfo getField(String name) {
        return this.fields == null ? null : this.fields.get(name);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDescriptor() {
        return null;
    }

    @Override
    public int getAccess() {
        return this.access;
    }

    @Override
    @NotNull
    public List<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return this.name;
    }
}

