/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarcompatibilitychecker.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.jarcompatibilitychecker.core.AnnotationCheckMode;
import net.minecraftforge.jarcompatibilitychecker.core.ClassInfoCache;
import net.minecraftforge.jarcompatibilitychecker.core.ClassInfoComparisonResults;
import net.minecraftforge.jarcompatibilitychecker.core.InternalAnnotationCheckMode;
import net.minecraftforge.jarcompatibilitychecker.data.AnnotationInfo;
import net.minecraftforge.jarcompatibilitychecker.data.ClassInfo;
import net.minecraftforge.jarcompatibilitychecker.data.FieldInfo;
import net.minecraftforge.jarcompatibilitychecker.data.MemberInfo;
import net.minecraftforge.jarcompatibilitychecker.data.MethodInfo;
import net.minecraftforge.jarcompatibilitychecker.sort.TopologicalSort;
import org.jetbrains.annotations.Nullable;

public class ClassInfoComparer {
    public static ClassInfoComparisonResults compare(boolean checkBinary, ClassInfoCache baseCache, ClassInfo baseClassInfo, ClassInfoCache concreteCache, @Nullable ClassInfo concreteClassInfo) {
        return ClassInfoComparer.compare(checkBinary, null, baseCache, baseClassInfo, concreteCache, concreteClassInfo);
    }

    public static ClassInfoComparisonResults compare(boolean checkBinary, @Nullable AnnotationCheckMode annotationCheckMode, ClassInfoCache baseCache, ClassInfo baseClassInfo, ClassInfoCache concreteCache, @Nullable ClassInfo concreteClassInfo) {
        return ClassInfoComparer.compare(checkBinary, annotationCheckMode, InternalAnnotationCheckMode.DEFAULT_INTERNAL_ANNOTATIONS, InternalAnnotationCheckMode.DEFAULT_MODE, baseCache, baseClassInfo, concreteCache, concreteClassInfo);
    }

    public static ClassInfoComparisonResults compare(boolean checkBinary, @Nullable AnnotationCheckMode annotationCheckMode, List<String> internalAnnotations, InternalAnnotationCheckMode internalAnnotationCheckMode, ClassInfoCache baseCache, ClassInfo baseClassInfo, ClassInfoCache concreteCache, @Nullable ClassInfo concreteClassInfo) {
        MemberInfo inputInfo;
        boolean isStatic;
        HashSet<String> concreteInterfaces;
        HashSet<String> baseInterfaces;
        AbstractSet missingInterfaces;
        boolean classFinal;
        ClassInfoComparisonResults results = new ClassInfoComparisonResults(baseClassInfo);
        boolean classInternal = ClassInfoComparer.isInternalApi(baseClassInfo, internalAnnotations, internalAnnotationCheckMode);
        if (classInternal && internalAnnotationCheckMode == InternalAnnotationCheckMode.SKIP) {
            return results;
        }
        boolean isClassError = !classInternal || internalAnnotationCheckMode == InternalAnnotationCheckMode.ERROR;
        boolean classVisible = ClassInfoComparer.isVisible(checkBinary, baseClassInfo.access);
        if (concreteClassInfo == null) {
            if (checkBinary) {
                results.addClassIncompatibility(baseClassInfo, "Class no longer exists", isClassError);
            } else if (classVisible) {
                results.addClassIncompatibility(baseClassInfo, "API class no longer exists", isClassError);
            }
            return results;
        }
        if (ClassInfoComparer.isVisibilityLowered(checkBinary, baseClassInfo.access, concreteClassInfo.access)) {
            results.addClassIncompatibility(baseClassInfo, "Class was lowered in visibility", isClassError);
        }
        boolean bl = classFinal = (baseClassInfo.access & 0x10) != 0;
        if (ClassInfoComparer.isMadeAbstract(classVisible, baseClassInfo.access, concreteClassInfo.access)) {
            results.addClassIncompatibility(baseClassInfo, "Class was made abstract", isClassError);
        }
        if (ClassInfoComparer.isMadeFinal(checkBinary, baseClassInfo.access, concreteClassInfo.access)) {
            results.addClassIncompatibility(baseClassInfo, "Class was made final", isClassError);
        }
        ClassInfoComparer.checkAnnotations(annotationCheckMode, results, baseClassInfo, isClassError, baseClassInfo.annotations, concreteClassInfo.annotations);
        if (baseClassInfo.superName != null) {
            ClassInfo superClassInfo = baseCache.getClassInfo(baseClassInfo.superName);
            boolean shouldCheckSuper = ClassInfoComparer.isVisible(checkBinary, superClassInfo.access);
            if (shouldCheckSuper && !ClassInfoComparer.hasSuperClass(concreteCache, concreteClassInfo, baseClassInfo.superName)) {
                results.addClassIncompatibility(baseClassInfo, String.format(Locale.ROOT, "Class missing superclass of %s", baseClassInfo.superName), isClassError);
            }
        }
        if (!(missingInterfaces = Sets.difference(baseInterfaces = new HashSet<String>(ClassInfoComparer.getParentClassNames(checkBinary, baseCache, baseClassInfo, false)), concreteInterfaces = new HashSet<String>(ClassInfoComparer.getParentClassNames(checkBinary, concreteCache, concreteClassInfo, false)))).isEmpty() && !checkBinary) {
            missingInterfaces = new HashSet<String>(missingInterfaces);
            missingInterfaces.removeIf(interfaceName -> {
                ClassInfo interfaceInfo = baseCache.getClassInfo((String)interfaceName);
                return (interfaceInfo.access & 5) == 0;
            });
        }
        if (!missingInterfaces.isEmpty()) {
            if (missingInterfaces.size() == 1) {
                results.addClassIncompatibility(baseClassInfo, String.format(Locale.ROOT, "Class missing interface: %s", missingInterfaces.iterator().next()), isClassError);
            } else {
                results.addClassIncompatibility(baseClassInfo, String.format(Locale.ROOT, "Class missing interfaces: %s", missingInterfaces), isClassError);
            }
        }
        List<ClassInfo> concreteParents = ClassInfoComparer.getParentClassInfos(checkBinary, concreteCache, concreteClassInfo, true);
        HashSet<MethodInfo> seenMethods = new HashSet<MethodInfo>();
        for (MethodInfo methodInfo : baseClassInfo.getMethods().values()) {
            isStatic = (methodInfo.access & 8) != 0;
            inputInfo = ClassInfoComparer.getMethodInfo(concreteClassInfo, concreteParents, isStatic, methodInfo.name, methodInfo.desc);
            boolean methodInternal = ClassInfoComparer.isInternalApi(methodInfo, internalAnnotations, internalAnnotationCheckMode);
            if (methodInternal && internalAnnotationCheckMode == InternalAnnotationCheckMode.SKIP) continue;
            boolean isMethodError = !methodInternal || internalAnnotationCheckMode == InternalAnnotationCheckMode.ERROR;
            boolean methodVisible = ClassInfoComparer.isVisible(checkBinary, methodInfo.access);
            if (inputInfo == null) {
                if (checkBinary) {
                    results.addMethodIncompatibility(methodInfo, "Method was removed", isMethodError);
                    continue;
                }
                if (!methodVisible) continue;
                results.addMethodIncompatibility(methodInfo, "API method was removed", isMethodError);
                continue;
            }
            seenMethods.add((MethodInfo)inputInfo);
            if (ClassInfoComparer.isVisibilityLowered(checkBinary, methodInfo.access, inputInfo.access)) {
                results.addMethodIncompatibility(methodInfo, "Method was lowered in visibility", isMethodError);
            }
            if (ClassInfoComparer.isMadeAbstract(classVisible, methodInfo.access, inputInfo.access)) {
                results.addMethodIncompatibility(methodInfo, "Method was made abstract", isMethodError);
            }
            if (!classFinal && ClassInfoComparer.isMadeFinal(checkBinary, methodInfo.access, inputInfo.access)) {
                results.addMethodIncompatibility(methodInfo, "Method was made final", isMethodError);
            }
            ClassInfoComparer.checkAnnotations(annotationCheckMode, results, methodInfo, isMethodError, methodInfo.annotations, inputInfo.annotations);
        }
        for (MethodInfo methodInfo : concreteClassInfo.getMethods().values()) {
            if (seenMethods.contains(methodInfo) || !classVisible || (methodInfo.access & 0x400) == 0) continue;
            results.addMethodIncompatibility(methodInfo, "Method was made abstract");
        }
        for (FieldInfo fieldInfo : baseClassInfo.getFields().values()) {
            isStatic = (fieldInfo.access & 8) != 0;
            inputInfo = ClassInfoComparer.getFieldInfo(concreteClassInfo, concreteParents, isStatic, fieldInfo.name);
            boolean fieldInternal = ClassInfoComparer.isInternalApi(fieldInfo, internalAnnotations, internalAnnotationCheckMode);
            if (fieldInternal && internalAnnotationCheckMode == InternalAnnotationCheckMode.SKIP) continue;
            boolean isFieldError = !fieldInternal || internalAnnotationCheckMode == InternalAnnotationCheckMode.ERROR;
            boolean fieldVisible = ClassInfoComparer.isVisible(checkBinary, fieldInfo.access);
            if (inputInfo == null) {
                if (checkBinary) {
                    results.addFieldIncompatibility(fieldInfo, "Field was removed", isFieldError);
                    continue;
                }
                if (!fieldVisible) continue;
                results.addFieldIncompatibility(fieldInfo, "API field was removed", isFieldError);
                continue;
            }
            if (ClassInfoComparer.isVisibilityLowered(checkBinary, fieldInfo.access, ((FieldInfo)inputInfo).access)) {
                results.addFieldIncompatibility(fieldInfo, "Field was lowered in visibility", isFieldError);
            }
            if (!classFinal && ClassInfoComparer.isMadeFinal(checkBinary, fieldInfo.access, ((FieldInfo)inputInfo).access)) {
                results.addFieldIncompatibility(fieldInfo, "Field was made final", isFieldError);
            }
            ClassInfoComparer.checkAnnotations(annotationCheckMode, results, fieldInfo, isFieldError, fieldInfo.annotations, ((FieldInfo)inputInfo).annotations);
        }
        return results;
    }

    public static boolean isVisibilityLowered(boolean checkBinary, int baseAccess, int inputAccess) {
        boolean basePublic = (baseAccess & 1) != 0;
        boolean baseProtected = (baseAccess & 4) != 0;
        boolean basePrivate = (baseAccess & 2) != 0;
        boolean inputPublic = (inputAccess & 1) != 0;
        boolean inputProtected = (inputAccess & 4) != 0;
        boolean inputPrivate = (inputAccess & 2) != 0;
        return basePublic && !inputPublic || baseProtected && !inputProtected && !inputPublic || checkBinary && !basePrivate && inputPrivate;
    }

    public static boolean isMadeAbstract(boolean classVisible, int baseAccess, int inputAccess) {
        return classVisible && (baseAccess & 0x400) == 0 && (inputAccess & 0x400) != 0;
    }

    public static boolean isVisible(boolean checkBinary, int access) {
        return checkBinary || (access & 5) != 0;
    }

    public static boolean isMadeFinal(boolean checkBinary, int baseAccess, int inputAccess) {
        return ClassInfoComparer.isVisible(checkBinary, baseAccess) && (baseAccess & 0x10) == 0 && (inputAccess & 0x10) != 0;
    }

    public static boolean isInternalApi(MemberInfo memberInfo, List<String> internalAnnotations, InternalAnnotationCheckMode checkMode) {
        if (checkMode == InternalAnnotationCheckMode.ERROR) {
            return false;
        }
        for (String internalAnnotation : internalAnnotations) {
            if (!memberInfo.hasAnnotation(internalAnnotation)) continue;
            return true;
        }
        return false;
    }

    public static <I extends MemberInfo> void checkAnnotations(@Nullable AnnotationCheckMode mode, ClassInfoComparisonResults results, I memberInfo, List<AnnotationInfo> baseAnnotations, List<AnnotationInfo> concreteAnnotations) {
        ClassInfoComparer.checkAnnotations(mode, results, memberInfo, true, baseAnnotations, concreteAnnotations);
    }

    public static <I extends MemberInfo> void checkAnnotations(@Nullable AnnotationCheckMode mode, ClassInfoComparisonResults results, I memberInfo, boolean isError, List<AnnotationInfo> baseAnnotations, List<AnnotationInfo> concreteAnnotations) {
        if (mode == null || baseAnnotations.isEmpty() && concreteAnnotations.isEmpty()) {
            return;
        }
        if (mode.checkAddition()) {
            ArrayList<AnnotationInfo> baseCopy = new ArrayList<AnnotationInfo>(baseAnnotations);
            for (AnnotationInfo concreteAnnotation : concreteAnnotations) {
                AnnotationInfo match = null;
                Iterator iterator = baseCopy.iterator();
                while (iterator.hasNext()) {
                    AnnotationInfo baseAnnotation = (AnnotationInfo)iterator.next();
                    if (!concreteAnnotation.equals(baseAnnotation) && !concreteAnnotation.desc.equals(baseAnnotation.desc)) continue;
                    iterator.remove();
                    match = baseAnnotation;
                    break;
                }
                if (match != null) continue;
                results.addAnnotationIncompatibility(mode, memberInfo, concreteAnnotation, "Annotation was added", isError);
            }
        }
    }

    public static boolean hasSuperClass(ClassInfoCache cache, ClassInfo classInfo, String superClass) {
        if (classInfo.superName == null) {
            return false;
        }
        do {
            if (superClass.equals(classInfo.superName)) {
                return true;
            }
            classInfo = cache.getClassInfo(classInfo.superName);
        } while (classInfo.superName != null);
        return false;
    }

    @Nullable
    public static MethodInfo getMethodInfo(ClassInfo classInfo, List<ClassInfo> parents, boolean isStatic, String methodName, String methodDesc) {
        MethodInfo methodInfo = classInfo.getMethod(methodName, methodDesc);
        if (methodInfo != null && (methodInfo.access & 8) == (isStatic ? 8 : 0)) {
            return methodInfo;
        }
        for (ClassInfo parent : parents) {
            methodInfo = parent.getMethod(methodName, methodDesc);
            if (methodInfo == null || (methodInfo.access & 0xA) != (isStatic ? 8 : 0)) continue;
            return methodInfo;
        }
        return null;
    }

    @Nullable
    public static FieldInfo getFieldInfo(ClassInfo classInfo, List<ClassInfo> parents, boolean isStatic, String fieldName) {
        FieldInfo fieldInfo = classInfo.getField(fieldName);
        if (fieldInfo != null && (fieldInfo.access & 8) == (isStatic ? 8 : 0)) {
            return fieldInfo;
        }
        for (ClassInfo parent : parents) {
            fieldInfo = parent.getField(fieldName);
            if (fieldInfo == null || (fieldInfo.access & 0xA) != (isStatic ? 8 : 0)) continue;
            return fieldInfo;
        }
        return null;
    }

    public static List<String> getParentClassNames(boolean checkBinary, ClassInfoCache cache, ClassInfo classInfo, boolean includeSuper) {
        HashSet<String> seenInterfaces;
        List<String> interfaces = classInfo.getInterfaces();
        if (interfaces.isEmpty() && classInfo.superName == null) {
            return ImmutableList.of();
        }
        MutableGraph parentGraph = GraphBuilder.directed().allowsSelfLoops(false).build();
        ArrayDeque<String> interfaceQueue = new ArrayDeque<String>();
        for (String interfaceName : interfaces) {
            parentGraph.putEdge(classInfo.name, interfaceName);
            interfaceQueue.add(interfaceName);
        }
        ClassInfo superInfo = classInfo;
        while (superInfo.superName != null) {
            boolean include;
            ClassInfo currentInfo = superInfo;
            superInfo = cache.getClassInfo(superInfo.superName);
            boolean bl = include = includeSuper && ClassInfoComparer.isVisible(checkBinary, currentInfo.access);
            if (include) {
                parentGraph.putEdge(currentInfo.name, superInfo.name);
            }
            for (String parentInterfaceName : superInfo.getInterfaces()) {
                parentGraph.putEdge(include ? superInfo.name : classInfo.name, parentInterfaceName);
                interfaceQueue.add(parentInterfaceName);
            }
        }
        HashSet<String> hashSet = seenInterfaces = interfaceQueue.isEmpty() ? null : new HashSet<String>();
        while (!interfaceQueue.isEmpty()) {
            String interfaceName = (String)interfaceQueue.remove();
            if (!seenInterfaces.add(interfaceName)) continue;
            ClassInfo interfaceInfo = cache.getClassInfo(interfaceName);
            for (String parentInterfaceName : interfaceInfo.getInterfaces()) {
                interfaceQueue.add(parentInterfaceName);
                parentGraph.putEdge(interfaceName, parentInterfaceName);
            }
        }
        List<String> parents = TopologicalSort.topologicalSort(parentGraph, null);
        if (!parents.isEmpty()) {
            parents.remove(0);
        }
        return parents;
    }

    public static List<ClassInfo> getParentClassInfos(boolean checkBinary, ClassInfoCache cache, ClassInfo classInfo, boolean includeSuper) {
        ArrayList<ClassInfo> parents = new ArrayList<ClassInfo>();
        for (String parentName : ClassInfoComparer.getParentClassNames(checkBinary, cache, classInfo, includeSuper)) {
            parents.add(cache.getClassInfo(parentName));
        }
        return parents;
    }
}

