/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarcompatibilitychecker;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraftforge.jarcompatibilitychecker.core.AnnotationCheckMode;
import net.minecraftforge.jarcompatibilitychecker.core.ClassInfoCache;
import net.minecraftforge.jarcompatibilitychecker.core.ClassInfoComparer;
import net.minecraftforge.jarcompatibilitychecker.core.ClassInfoComparisonResults;
import net.minecraftforge.jarcompatibilitychecker.core.Incompatibility;
import net.minecraftforge.jarcompatibilitychecker.core.InternalAnnotationCheckMode;
import net.minecraftforge.jarcompatibilitychecker.data.ClassInfo;
import org.jetbrains.annotations.Nullable;

public class JarCompatibilityChecker {
    private final File baseJar;
    private final File inputJar;
    private final boolean checkBinary;
    @Nullable
    private final AnnotationCheckMode annotationCheckMode;
    private final List<String> internalAnnotations;
    private final InternalAnnotationCheckMode internalAnnotationCheckMode;
    private final List<File> commonLibs;
    private final List<File> baseLibs;
    private final List<File> concreteLibs;
    private final Consumer<String> stdLogger;
    private final Consumer<String> errLogger;

    public JarCompatibilityChecker(File baseJar, File inputJar, boolean checkBinary, List<File> commonLibs, List<File> baseLibs, List<File> concreteLibs, Consumer<String> stdLogger, Consumer<String> errLogger) {
        this(baseJar, inputJar, checkBinary, null, commonLibs, baseLibs, concreteLibs, stdLogger, errLogger);
    }

    public JarCompatibilityChecker(File baseJar, File inputJar, boolean checkBinary, @Nullable AnnotationCheckMode annotationCheckMode, List<File> commonLibs, List<File> baseLibs, List<File> concreteLibs, Consumer<String> stdLogger, Consumer<String> errLogger) {
        this(baseJar, inputJar, checkBinary, annotationCheckMode, InternalAnnotationCheckMode.DEFAULT_INTERNAL_ANNOTATIONS, InternalAnnotationCheckMode.DEFAULT_MODE, commonLibs, baseLibs, concreteLibs, stdLogger, errLogger);
    }

    public JarCompatibilityChecker(File baseJar, File inputJar, boolean checkBinary, @Nullable AnnotationCheckMode annotationCheckMode, List<String> internalAnnotations, InternalAnnotationCheckMode internalAnnotationCheckMode, List<File> commonLibs, List<File> baseLibs, List<File> concreteLibs, Consumer<String> stdLogger, Consumer<String> errLogger) {
        this.baseJar = baseJar;
        this.inputJar = inputJar;
        this.checkBinary = checkBinary;
        this.annotationCheckMode = annotationCheckMode;
        this.internalAnnotations = internalAnnotations == InternalAnnotationCheckMode.DEFAULT_INTERNAL_ANNOTATIONS ? internalAnnotations : internalAnnotations.stream().map(s -> {
            boolean inDescForm = s.indexOf(59) == s.length() - 1;
            return inDescForm ? s.replace('.', '/') : 'L' + s.replace('.', '/') + ';';
        }).collect(Collectors.toList());
        this.internalAnnotationCheckMode = internalAnnotationCheckMode;
        this.commonLibs = commonLibs;
        this.baseLibs = baseLibs;
        this.concreteLibs = concreteLibs;
        this.stdLogger = stdLogger;
        this.errLogger = errLogger;
    }

    private void log(String message) {
        this.stdLogger.accept(message);
    }

    private void logError(String message) {
        this.errLogger.accept(message);
    }

    public int check() throws IOException {
        this.log("Compatibility mode: " + (this.checkBinary ? "Binary" : "API"));
        this.log("Annotation check mode: " + (this.annotationCheckMode == null ? "NONE" : this.annotationCheckMode));
        this.log("Internal API annotation check mode: " + (Object)((Object)this.internalAnnotationCheckMode));
        this.log("Internal API annotations: " + this.internalAnnotations);
        this.log("Base JAR: " + this.baseJar.getAbsolutePath());
        this.log("Input JAR: " + this.inputJar.getAbsolutePath());
        for (File baseLib : this.baseLibs) {
            this.log("Base Library: " + baseLib.getAbsolutePath());
        }
        for (File concreteLib : this.concreteLibs) {
            this.log("Concrete Library: " + concreteLib.getAbsolutePath());
        }
        for (File commonLib : this.commonLibs) {
            this.log("Common Library: " + commonLib.getAbsolutePath());
        }
        ArrayList<File> baseFiles = new ArrayList<File>(this.baseLibs);
        baseFiles.addAll(this.commonLibs);
        ClassInfoCache baseCache = ClassInfoCache.fromJarFile(this.baseJar, baseFiles);
        ArrayList<File> concreteFiles = new ArrayList<File>(this.concreteLibs);
        concreteFiles.addAll(this.commonLibs);
        ClassInfoCache concreteCache = ClassInfoCache.fromJarFile(this.inputJar, concreteFiles);
        ArrayList<ClassInfoComparisonResults> classIncompatibilities = new ArrayList<ClassInfoComparisonResults>();
        for (Map.Entry<String, ClassInfo> baseEntry : baseCache.getMainClasses().entrySet()) {
            ClassInfo concreteClassInfo;
            String baseClassName = baseEntry.getKey();
            ClassInfo baseClassInfo = baseEntry.getValue();
            ClassInfoComparisonResults results = ClassInfoComparer.compare(this.checkBinary, this.annotationCheckMode, this.internalAnnotations, this.internalAnnotationCheckMode, baseCache, baseClassInfo, concreteCache, concreteClassInfo = concreteCache.getMainClassInfo(baseClassName));
            if (!results.isIncompatible()) continue;
            classIncompatibilities.add(results);
        }
        if (!classIncompatibilities.isEmpty()) {
            int errorCount = 0;
            int warningCount = 0;
            for (ClassInfoComparisonResults compareResults : classIncompatibilities) {
                for (Incompatibility<?> incompatibility : compareResults.getIncompatibilities()) {
                    if (incompatibility.isError()) {
                        ++errorCount;
                        continue;
                    }
                    ++warningCount;
                }
            }
            this.logError("Incompatibilities found: " + errorCount + " errors, " + warningCount + " warnings");
            for (ClassInfoComparisonResults compareResults : classIncompatibilities) {
                this.logError(compareResults.classInfo.name + ":");
                for (Incompatibility<?> incompatibility : compareResults.getIncompatibilities()) {
                    this.logError("- " + (incompatibility.isError() ? "error: " : "warning: ") + incompatibility);
                }
            }
            return errorCount;
        }
        this.log("No incompatibilities found");
        return 0;
    }
}

