/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarcompatibilitychecker;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import joptsimple.util.EnumConverter;
import net.minecraftforge.jarcompatibilitychecker.JarCompatibilityChecker;
import net.minecraftforge.jarcompatibilitychecker.core.AnnotationCheckMode;
import net.minecraftforge.jarcompatibilitychecker.core.InternalAnnotationCheckMode;

public class ConsoleTool {
    public static void main(String[] args) {
        try {
            OptionSet options;
            OptionParser parser = new OptionParser();
            OptionSpecBuilder apiO = parser.accepts("api", "Enables the API compatibility checking mode");
            OptionSpecBuilder binaryO = parser.accepts("binary", "Enables the binary compatibility checking mode. This option will override the API compatibility flag. Defaults to true.");
            ArgumentAcceptingOptionSpec<File> baseJarO = parser.accepts("base-jar", "Base JAR file that will be matched against for compatibility").withRequiredArg().ofType(File.class).required();
            ArgumentAcceptingOptionSpec<File> inputJarO = parser.accepts("input-jar", "JAR file to validate against the base JAR").withRequiredArg().ofType(File.class).required();
            ArgumentAcceptingOptionSpec<File> libO = parser.acceptsAll(ImmutableList.of("lib", "library"), "Libraries that the base JAR and input JAR both use").withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec<File> baseLibO = parser.acceptsAll(ImmutableList.of("base-lib", "base-library"), "Libraries that only the base JAR uses").withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec<File> concreteLibO = parser.acceptsAll(ImmutableList.of("concrete-lib", "concrete-library"), "Libraries that only the input JAR uses").withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec<AnnotationCheckMode> annotationCheckModeO = parser.acceptsAll(ImmutableList.of("annotation-check-mode", "ann-mode"), "What mode to use for checking annotations").withRequiredArg().withValuesConvertedBy(new EnumConverter<AnnotationCheckMode>(AnnotationCheckMode.class){});
            ArgumentAcceptingOptionSpec<String> internalAnnotationO = parser.acceptsAll(ImmutableList.of("internal-annotation", "internal-ann"), "The fully resolved classname of an allowed internal API annotation").withRequiredArg().defaultsTo((String[])InternalAnnotationCheckMode.DEFAULT_INTERNAL_ANNOTATIONS.toArray(new String[0]));
            ArgumentAcceptingOptionSpec<InternalAnnotationCheckMode> internalAnnotationCheckModeO = parser.acceptsAll(ImmutableList.of("internal-annotation-check-mode", "internal-ann-mode"), "What mode to use for checking elements marked with an internal API annotation").withRequiredArg().withValuesConvertedBy(new EnumConverter<InternalAnnotationCheckMode>(InternalAnnotationCheckMode.class){}).defaultsTo(InternalAnnotationCheckMode.DEFAULT_MODE, (InternalAnnotationCheckMode[])new InternalAnnotationCheckMode[0]);
            try {
                options = parser.parse(args);
            }
            catch (OptionException ex) {
                System.err.println("Error: " + ex.getMessage());
                System.err.println();
                parser.printHelpOn(System.err);
                System.exit(-1);
                return;
            }
            File baseJar = options.valueOf(baseJarO);
            File inputJar = options.valueOf(inputJarO);
            List<File> commonLibs = options.valuesOf(libO);
            List<File> baseLibs = options.valuesOf(baseLibO);
            List<File> concreteLibs = options.valuesOf(concreteLibO);
            boolean checkBinary = !options.has(apiO) || options.has(binaryO);
            AnnotationCheckMode annotationCheckMode = options.valueOf(annotationCheckModeO);
            List<String> internalAnnotations = options.valuesOf(internalAnnotationO);
            InternalAnnotationCheckMode internalAnnotationCheckMode = options.valueOf(internalAnnotationCheckModeO);
            JarCompatibilityChecker checker = new JarCompatibilityChecker(baseJar, inputJar, checkBinary, annotationCheckMode, internalAnnotations, internalAnnotationCheckMode, commonLibs, baseLibs, concreteLibs, System.out::println, System.err::println);
            int incompatibilities = checker.check();
            System.exit(Math.min(125, incompatibilities));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

