/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fart.api.Inheritance;
import net.minecraftforge.fart.api.Renamer;
import net.minecraftforge.fart.api.Transformer;
import net.minecraftforge.fart.internal.RenamerImpl;
import net.minecraftforge.srgutils.IMappingFile;

public class RenamerBuilder
implements Renamer.Builder {
    private final Inheritance inh = Inheritance.create();
    private File input;
    private File output;
    private List<File> libraries = new ArrayList<File>();
    private List<Transformer> transformers = new ArrayList<Transformer>();
    private int threads = Runtime.getRuntime().availableProcessors();

    @Override
    public Renamer.Builder input(File value) {
        this.input = value;
        return this;
    }

    @Override
    public Renamer.Builder output(File value) {
        this.output = value;
        return this;
    }

    @Override
    public Renamer.Builder lib(File value) {
        this.libraries.add(value);
        return this;
    }

    @Override
    public Renamer.Builder map(File value) {
        try {
            this.add(Transformer.createRenamer(this.inh, IMappingFile.load(value)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public Renamer.Builder add(Transformer value) {
        this.transformers.add(value);
        return this;
    }

    @Override
    public Renamer.Builder threads(int value) {
        this.threads = value;
        return this;
    }

    @Override
    public Renamer build() {
        return new RenamerImpl(this.input, this.output, this.libraries, this.transformers, this.inh, this.threads);
    }
}

