/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraftforge.fart.api.Inheritance;
import net.minecraftforge.srgutils.IMappingFile;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;

class EnhancedRemapper
extends Remapper {
    private final Inheritance inh;
    private final IMappingFile map;
    private final Map<String, Optional<MClass>> resolved = new ConcurrentHashMap<String, Optional<MClass>>();

    public EnhancedRemapper(Inheritance inh, IMappingFile map) {
        this.inh = inh;
        this.map = map;
    }

    @Override
    public String mapModuleName(String name) {
        return name;
    }

    @Override
    public String mapAnnotationAttributeName(String descriptor, String name) {
        return name;
    }

    @Override
    public String mapInvokeDynamicMethodName(String name, String descriptor) {
        return name;
    }

    @Override
    public String mapMethodName(String owner, String name, String descriptor) {
        return this.getClass(owner).flatMap(c -> c.getMethod(name, descriptor)).map(MClass.MMethod::getMapped).orElse(name);
    }

    @Override
    public String mapRecordComponentName(String owner, String name, String descriptor) {
        return this.mapFieldName(owner, name, descriptor);
    }

    @Override
    public String mapFieldName(String owner, String name, String descriptor) {
        return this.getClass(owner).flatMap(c -> c.getField(name, descriptor)).map(MClass.MField::getMapped).orElse(name);
    }

    @Override
    public String mapPackageName(String name) {
        return this.map.remapPackage(name);
    }

    @Override
    public String map(String name) {
        return this.getClass(name).map(MClass::getMapped).orElse(this.map.remapClass(name));
    }

    public String mapParameterName(String owner, String methodName, String methodDescriptor, int index, String paramName) {
        return this.getClass(owner).flatMap(c -> c.getMethod(methodName, methodDescriptor)).map((? super T m) -> m.mapParameter(index, paramName)).orElse(paramName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<MClass> getClass(String cls) {
        if (cls == null || cls.charAt(0) == '[') {
            return Optional.empty();
        }
        Optional<MClass> ret = this.resolved.get(cls);
        if (ret == null) {
            String string = cls.intern();
            synchronized (string) {
                ret = this.resolved.get(cls);
                if (ret == null) {
                    ret = this.computeClass(cls);
                    this.resolved.put(cls, ret);
                }
            }
        }
        return ret;
    }

    private Inheritance getInheritance() {
        return this.inh;
    }

    private IMappingFile getMap() {
        return this.map;
    }

    private Optional<MClass> computeClass(String cls) {
        Optional<? extends Inheritance.IClassInfo> icls = this.getInheritance().getClass(cls);
        IMappingFile.IClass mcls = this.map.getClass(cls);
        if (!icls.isPresent() && mcls == null) {
            return Optional.empty();
        }
        return Optional.of(new MClass(icls.orElse(null), mcls));
    }

    private class MClass {
        private final Inheritance.IClassInfo icls;
        private final IMappingFile.IClass mcls;
        private final String mappedName;
        private final List<MClass> parents;
        private final Map<String, Optional<MField>> fields = new ConcurrentHashMap<String, Optional<MField>>();
        private Collection<Optional<MField>> fieldsView = Collections.unmodifiableCollection(this.fields.values());
        private final Map<String, Optional<MMethod>> methods = new ConcurrentHashMap<String, Optional<MMethod>>();
        private Collection<Optional<MMethod>> methodsView = Collections.unmodifiableCollection(this.methods.values());

        private void log(String line) {
            System.out.println(line);
        }

        MClass(Inheritance.IClassInfo icls, IMappingFile.IClass mcls) {
            if (icls == null && mcls == null) {
                throw new IllegalArgumentException("Can't pass in both nulls..");
            }
            this.icls = icls;
            this.mcls = mcls;
            String string = this.mappedName = mcls == null ? EnhancedRemapper.this.getMap().remapClass(icls.getName()) : mcls.getMapped();
            if (icls != null) {
                ArrayList parents = new ArrayList();
                EnhancedRemapper.this.getClass(icls.getSuper()).ifPresent(parents::add);
                icls.getInterfaces().stream().map(x$0 -> EnhancedRemapper.this.getClass(x$0)).forEach(o -> o.ifPresent(parents::add));
                this.parents = Collections.unmodifiableList(parents);
                icls.getFields().stream().map(f -> new MField((Inheritance.IFieldInfo)f, mcls == null ? null : mcls.getField(f.getName()))).forEach(f -> this.fields.put(f.getKey(), Optional.of(f)));
                icls.getMethods().stream().map(m -> new MMethod((Inheritance.IMethodInfo)m, mcls == null ? null : mcls.getMethod(m.getName(), m.getDescriptor()))).forEach(m -> this.methods.put(m.getKey(), Optional.of(m)));
            } else {
                this.parents = Collections.emptyList();
                mcls.getFields().stream().map(f -> new MField(null, (IMappingFile.IField)f)).forEach(f -> this.fields.put(f.getKey(), Optional.of(f)));
                mcls.getMethods().stream().map(m -> new MMethod(null, (IMappingFile.IMethod)m)).forEach(m -> this.methods.put(m.getKey(), Optional.of(m)));
            }
            for (MClass cls : this.parents) {
                for (Optional<MField> optional : cls.getFields()) {
                    MField fld;
                    Optional<MField> existing;
                    if (!optional.isPresent() || (existing = this.fields.get((fld = (MField)optional.orElse(null)).getKey())) != null && existing.isPresent()) continue;
                    this.fields.put(fld.getKey(), optional);
                }
                for (Optional<Object> optional : cls.getMethods()) {
                    if (!optional.isPresent()) continue;
                    MMethod mtd = optional.orElse(null);
                    if (cls.isInterface() && !mtd.isInterfaceInheritable()) continue;
                    Optional<MMethod> existingO = this.methods.get(mtd.getKey());
                    if (existingO == null || !existingO.isPresent()) {
                        this.methods.put(mtd.getKey(), optional);
                        continue;
                    }
                    MMethod existing = existingO.orElse(null);
                    if (!existing.hasMapping() && !existing.getName().equals(mtd.getMapped())) {
                        if (!existing.getMapped().equals(mtd.getMapped())) {
                            this.log("Conflictig propagated mapping for " + existing + " from " + mtd + ": " + existing.getMapped() + " -> " + mtd.getMapped());
                        }
                        existing.setMapped(mtd.getMapped());
                        continue;
                    }
                    if (mtd.hasMapping() || mtd.getName().equals(existing.getMapped())) continue;
                    if (!mtd.getMapped().equals(existing.getMapped())) {
                        this.log("Conflictig propagated mapping for " + mtd + " from " + existing + ": " + mtd.getMapped() + " -> " + existing.getMapped());
                    }
                    mtd.setMapped(existing.getMapped());
                }
            }
        }

        public String getName() {
            return this.icls != null ? this.icls.getName() : this.mcls.getOriginal();
        }

        public String getMapped() {
            return this.mappedName;
        }

        public int getAccess() {
            if (this.icls == null) {
                return 2;
            }
            return this.icls.getAccess();
        }

        public boolean isInterface() {
            return (this.getAccess() & 0x200) != 0;
        }

        public Collection<Optional<MField>> getFields() {
            return this.fieldsView;
        }

        public Optional<MField> getField(String name, @Nullable String desc) {
            if (desc == null) {
                return this.fields.computeIfAbsent(name, k -> Optional.empty());
            }
            return this.fields.computeIfAbsent(name + desc, k -> this.fields.computeIfAbsent(name, k2 -> Optional.empty()));
        }

        public Collection<Optional<MMethod>> getMethods() {
            return this.methodsView;
        }

        public Optional<MMethod> getMethod(String name, String desc) {
            return this.methods.computeIfAbsent(name + desc, k -> Optional.empty());
        }

        public String toString() {
            return this.getName();
        }

        public class MMethod {
            private final Inheritance.IMethodInfo imtd;
            private final IMappingFile.IMethod mmtd;
            private String mappedName;
            private final String[] params;
            private final String key;

            MMethod(Inheritance.IMethodInfo imtd, IMappingFile.IMethod mmtd) {
                this.imtd = imtd;
                this.mmtd = mmtd;
                if (mmtd != null && !mmtd.getDescriptor().contains("()")) {
                    ArrayList<String> tmp = new ArrayList<String>();
                    if (!mmtd.getMetadata().containsKey("is_static")) {
                        tmp.add("this");
                    }
                    Type[] args = Type.getArgumentTypes(mmtd.getDescriptor());
                    for (int x = 0; x < args.length; ++x) {
                        String name = mmtd.remapParameter(x, null);
                        tmp.add(name);
                        if (args[x].getSize() != 2) continue;
                        tmp.add(name);
                    }
                    this.params = tmp.toArray(new String[tmp.size()]);
                } else {
                    this.params = null;
                }
                this.key = this.getName() + this.getDescriptor();
            }

            public String getName() {
                return this.imtd != null ? this.imtd.getName() : this.mmtd.getOriginal();
            }

            public String getDescriptor() {
                return this.imtd != null ? this.imtd.getDescriptor() : this.mmtd.getDescriptor();
            }

            public String getMapped() {
                return this.mappedName == null ? (this.mmtd == null ? this.getName() : this.mmtd.getMapped()) : this.mappedName;
            }

            public String getKey() {
                return this.key;
            }

            public void setMapped(String name) {
                this.mappedName = name;
            }

            public boolean hasMapping() {
                return this.mmtd != null;
            }

            public int getAccess() {
                if (this.imtd == null) {
                    return 2;
                }
                return this.imtd.getAccess();
            }

            public boolean isInterfaceInheritable() {
                return (this.getAccess() & 0xA) == 0;
            }

            public String mapParameter(int index, String name) {
                return this.params != null && index >= 0 && index < this.params.length ? this.params[index] : name;
            }

            public String toString() {
                return MClass.this.getName() + '/' + this.getName() + this.getDescriptor();
            }
        }

        public class MField {
            private final Inheritance.IFieldInfo ifld;
            private final IMappingFile.IField mfld;
            private final String mappedName;
            private final String key;

            MField(Inheritance.IFieldInfo ifld, IMappingFile.IField mfld) {
                this.ifld = ifld;
                this.mfld = mfld;
                this.mappedName = mfld == null ? ifld.getName() : mfld.getMapped();
                this.key = this.getDescriptor() == null ? this.getName() : this.getName() + this.getDescriptor();
            }

            public String getName() {
                return this.ifld != null ? this.ifld.getName() : this.mfld.getOriginal();
            }

            public String getDescriptor() {
                return this.ifld != null ? this.ifld.getDescriptor() : this.mfld.getDescriptor();
            }

            public String getMapped() {
                return this.mappedName;
            }

            public String getKey() {
                return this.key;
            }

            public String toString() {
                return MClass.this.getName() + '/' + this.getName() + ' ' + this.getDescriptor();
            }
        }
    }
}

