/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

class AsyncHelper {
    private final ExecutorService exec;

    AsyncHelper(int threads) {
        if (threads <= 0) {
            throw new IllegalArgumentException("Really.. no threads to process things? What do you want me to use a genie?");
        }
        this.exec = threads == 1 ? Executors.newSingleThreadExecutor() : Executors.newWorkStealingPool(threads);
    }

    public <I, O> void consumeAll(Collection<? extends I> inputs, Consumer<I> consumer) {
        Function<Object, Callable> toCallable = i -> () -> {
            consumer.accept(i);
            return null;
        };
        this.invokeAll(inputs.stream().map(toCallable).collect(Collectors.toList()));
    }

    public <I, O> List<O> invokeAll(Collection<? extends I> inputs, Function<I, O> converter) {
        Function<Object, Callable> toCallable = i -> () -> converter.apply(i);
        return this.invokeAll(inputs.stream().map(toCallable).collect(Collectors.toList()));
    }

    public <O> List<O> invokeAll(Collection<? extends Callable<O>> tasks) {
        try {
            ArrayList ret = new ArrayList();
            List processed = this.exec.invokeAll(tasks);
            for (Future future : processed) {
                Object done = future.get();
                if (done == null) continue;
                ret.add(done);
            }
            return ret;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        this.exec.shutdown();
    }
}

