/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.api;

import java.util.Collection;
import java.util.Collections;
import net.minecraftforge.fart.api.Inheritance;
import net.minecraftforge.fart.internal.EntryImpl;
import net.minecraftforge.fart.internal.RenamingTransformer;
import net.minecraftforge.srgutils.IMappingFile;

public interface Transformer {
    default public ClassEntry process(ClassEntry entry) {
        return entry;
    }

    default public ManifestEntry process(ManifestEntry entry) {
        return entry;
    }

    default public ResourceEntry process(ResourceEntry entry) {
        return entry;
    }

    default public Collection<? extends Entry> getExtras() {
        return Collections.emptyList();
    }

    public static Transformer createRenamer(Inheritance inh, IMappingFile map) {
        return new RenamingTransformer(inh, map);
    }

    public static interface ManifestEntry
    extends Entry {
        public static ManifestEntry create(long time, byte[] data) {
            return new EntryImpl.ManifestEntry(time, data);
        }
    }

    public static interface ResourceEntry
    extends Entry {
        public static ResourceEntry create(String name, long time, byte[] data) {
            return new EntryImpl.ResourceEntry(name, time, data);
        }
    }

    public static interface ClassEntry
    extends Entry {
        public static ClassEntry create(String name, long time, byte[] data) {
            return new EntryImpl.ClassEntry(name, time, data);
        }

        public static ClassEntry create(String cls, long time, byte[] data, int version) {
            return ClassEntry.create("META-INF/versions/" + version + '/' + cls + ".class", time, data);
        }

        public String getClassName();

        public boolean isMultiRelease();

        public int getVersion();
    }

    public static interface Entry {
        public static final long STABLE_TIMESTAMP = 946684800L;

        public long getTime();

        public String getName();

        public byte[] getData();

        public Entry process(Transformer var1);
    }
}

