/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import net.minecraftforge.fart.IdentifierFixer;
import net.minecraftforge.fart.ParameterAnnotationFixer;
import net.minecraftforge.fart.api.Renamer;

public class Main {
    public static void main(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> inputO = parser.accepts("input", "Input jar file").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> outputO = parser.accepts("output", "Output jar file, if unspecifed, overwrites input").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> mapO = parser.accepts("map", "Mapping file to apply").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> logO = parser.accepts("log", "File to log data to, optional, defaults to System.out").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> libO = parser.acceptsAll(Arrays.asList("lib", "e"), "Additional library to use for inheritence").withRequiredArg().ofType(File.class);
        OptionSpecBuilder fixAnnO = parser.accepts("ann-fix", "Fixes misaligned parameter annotations caused by Proguard.");
        ArgumentAcceptingOptionSpec<IdentifierFixer.Config> fixIdsO = parser.accepts("ids-fix", "Fixes local variables that are not valid java identifiers.").withOptionalArg().withValuesConvertedBy(new IDConfig()).defaultsTo(IdentifierFixer.Config.ALL, (IdentifierFixer.Config[])new IdentifierFixer.Config[0]);
        ArgumentAcceptingOptionSpec<Integer> threadsO = parser.accepts("threads", "Number of threads to use, defaults to processor count.").withRequiredArg().ofType(Integer.class).defaultsTo(Runtime.getRuntime().availableProcessors(), (Integer[])new Integer[0]);
        OptionSet options = parser.parse(Main.expandArgs(args));
        if (options.has(logO)) {
            PrintStream out = System.out;
            PrintStream log = new PrintStream(new FileOutputStream(options.valueOf(logO)));
            Main.hookStdOut(ln -> {
                out.println((String)ln);
                log.println((String)ln);
            });
        } else {
            Main.hookStdOut(System.out::println);
        }
        Main.log("Forge Auto Renaming Tool v" + Main.getVersion());
        Main.log("log: " + (options.has(logO) ? options.valueOf(logO).getAbsolutePath() : "null"));
        Renamer.Builder builder = Renamer.builder();
        Main.log("threads: " + options.valueOf(threadsO));
        builder.threads(options.valueOf(threadsO));
        File mapF = options.valueOf(mapO);
        Main.log("map: " + mapF.getAbsolutePath());
        builder.map(mapF);
        if (options.has(libO)) {
            for (File lib : options.valuesOf(libO)) {
                Main.log("lib: " + lib.getAbsolutePath());
                builder.lib(lib);
            }
        }
        File inputF = options.valueOf(inputO);
        Main.log("input: " + inputF.getAbsolutePath());
        builder.input(inputF);
        File outputF = options.has(outputO) ? options.valueOf(outputO) : inputF;
        Main.log("output: " + outputF.getAbsolutePath());
        builder.output(outputF);
        if (options.has(fixAnnO)) {
            Main.log("Fix Annotations: true");
            builder.add(new ParameterAnnotationFixer());
        } else {
            Main.log("Fix Annotations: false");
        }
        if (options.has(fixIdsO)) {
            Main.log("Fix Identifiers: " + (Object)((Object)options.valueOf(fixIdsO)));
            builder.add(new IdentifierFixer(options.valueOf(fixIdsO)));
        } else {
            Main.log("Fix Identifiers: false");
        }
        Renamer renamer = builder.build();
        renamer.run();
    }

    private static void log(String line) {
        System.out.println(line);
    }

    private static String[] expandArgs(String[] args) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (int x = 0; x < args.length; ++x) {
            if (args[x].equals("--cfg")) {
                if (x + 1 == args.length) {
                    throw new IllegalArgumentException("No value specified for '--cfg'");
                }
                Files.lines(Paths.get(args[++x], new String[0])).forEach(ret::add);
                continue;
            }
            if (args[x].startsWith("--cfg=")) {
                Files.lines(Paths.get(args[x].substring(6), new String[0])).forEach(ret::add);
                continue;
            }
            ret.add(args[x]);
        }
        return ret.toArray(new String[ret.size()]);
    }

    private static String getVersion() {
        String ver = Main.class.getPackage().getImplementationVersion();
        return ver == null ? "UNKNOWN" : ver;
    }

    static void hookStdOut(final Consumer<String> consumer) {
        OutputStream monitorStream = new OutputStream(){
            private byte[] buf = new byte[128];
            private int index = 0;

            private void ensure(int len) {
                if (this.buf.length <= len) {
                    int max;
                    byte[] old = this.buf;
                    for (max = this.buf.length << 1; max > 0 && max < len; max += 1024) {
                    }
                    if (max < 0) {
                        throw new OutOfMemoryError();
                    }
                    this.buf = Arrays.copyOf(old, max);
                }
            }

            private void send() {
                if (this.index == 0) {
                    return;
                }
                String line = new String(this.buf, 0, this.index);
                this.buf = new byte[128];
                this.index = 0;
                consumer.accept(line);
            }

            @Override
            public synchronized void write(int b) {
                if (b == 13 || b == 10) {
                    this.send();
                } else {
                    this.ensure(this.index + 1);
                    this.buf[this.index++] = (byte)b;
                }
            }

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                if (off < 0 || len < 0 || off > b.length || off + len >= b.length) {
                    throw new IndexOutOfBoundsException();
                }
                while (len > 0) {
                    byte i;
                    int x;
                    for (x = 0; x < len && (i = b[off + x]) != 13 && i != 10; ++x) {
                    }
                    this.ensure(this.index + x);
                    System.arraycopy(b, off, this.buf, this.index, x);
                    this.index += x;
                    if (x != len) {
                        this.send();
                        len -= ++x;
                        if (b[(off += x) - 1] != 13 || b[off] != 10) continue;
                        --len;
                        ++off;
                        continue;
                    }
                    off += len;
                    len = 0;
                }
            }
        };
        System.setOut(new PrintStream(monitorStream));
        System.setErr(new PrintStream(monitorStream));
    }

    private static class IDConfig
    implements ValueConverter<IdentifierFixer.Config> {
        private IDConfig() {
        }

        @Override
        public IdentifierFixer.Config convert(String value) {
            return IdentifierFixer.Config.valueOf(value.toUpperCase(Locale.ENGLISH));
        }

        @Override
        public Class<? extends IdentifierFixer.Config> valueType() {
            return IdentifierFixer.Config.class;
        }

        @Override
        public String valuePattern() {
            return Arrays.stream(IdentifierFixer.Config.values()).map(Enum::name).collect(Collectors.joining("|"));
        }
    }
}

