/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fart.api.Transformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class IdentifierFixer
implements Transformer {
    private static final int MAX_ASM_VERSION = 589824;
    private final Config config;

    IdentifierFixer(Config config) {
        this.config = config;
    }

    @Override
    public Transformer.ClassEntry process(Transformer.ClassEntry entry) {
        ClassReader reader = new ClassReader(entry.getData());
        ClassWriter writer = new ClassWriter(reader, 0);
        Fixer fixer = new Fixer((ClassVisitor)writer);
        reader.accept(fixer, 0);
        if (!fixer.madeChange()) {
            return entry;
        }
        return Transformer.ClassEntry.create(entry.getName(), entry.getTime(), writer.toByteArray());
    }

    private class Fixer
    extends ClassVisitor {
        private boolean madeChange;

        public Fixer(ClassVisitor parent) {
            super(589824, parent);
            this.madeChange = false;
        }

        public boolean madeChange() {
            return this.madeChange;
        }

        @Override
        public final MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor parent = super.visitMethod(access, name, descriptor, signature, exceptions);
            return new MethodVisitor(589824, parent){
                private final Map<Integer, Integer> seen;
                {
                    this.seen = new HashMap<Integer, Integer>();
                }

                @Override
                public void visitLocalVariable(String pname, String pdescriptor, String psignature, Label start, Label end, int index) {
                    String newName = this.fixName(pname, index);
                    super.visitLocalVariable(newName, pdescriptor, psignature, start, end, index);
                }

                private String fixName(String name, int index) {
                    boolean valid;
                    block5: {
                        block6: {
                            block4: {
                                valid = true;
                                if (!name.isEmpty()) break block4;
                                valid = false;
                                break block5;
                            }
                            if (IdentifierFixer.this.config != Config.SNOWMEN) break block6;
                            if ('\u2603' != name.charAt(0)) break block5;
                            valid = false;
                            break block5;
                        }
                        if (name.isEmpty() || !Character.isJavaIdentifierStart(name.charAt(0))) {
                            valid = false;
                        } else {
                            for (int x = 1; x < name.length(); ++x) {
                                if (Character.isJavaIdentifierPart(name.charAt(x))) continue;
                                valid = false;
                                break;
                            }
                        }
                    }
                    if (valid) {
                        return name;
                    }
                    Fixer.this.madeChange = true;
                    int version = this.seen.computeIfAbsent(index, k -> 0) + 1;
                    this.seen.put(index, version);
                    return "lvt_" + index + '_' + version + '_';
                }
            };
        }
    }

    static enum Config {
        ALL,
        SNOWMEN;

    }
}

