/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraftforge.fart.api.Inheritance;
import net.minecraftforge.fart.api.Transformer;
import net.minecraftforge.fart.internal.EnhancedClassRemapper;
import net.minecraftforge.fart.internal.EnhancedRemapper;
import net.minecraftforge.srgutils.IMappingFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class RenamingTransformer
implements Transformer {
    private static final String ABSTRACT_FILE = "fernflower_abstract_parameter_names.txt";
    private final EnhancedRemapper remapper;
    private final Set<String> abstractParams = ConcurrentHashMap.newKeySet();

    public RenamingTransformer(Inheritance inh, IMappingFile map, Consumer<String> log) {
        this.remapper = new EnhancedRemapper(inh, map, log);
    }

    @Override
    public Transformer.ClassEntry process(Transformer.ClassEntry entry) {
        ClassReader reader = new ClassReader(entry.getData());
        ClassWriter writer = new ClassWriter(reader, 0);
        EnhancedClassRemapper remapper = new EnhancedClassRemapper((ClassVisitor)writer, this.remapper, this);
        reader.accept((ClassVisitor)remapper, 0);
        byte[] data = writer.toByteArray();
        String newName = this.remapper.map(entry.getClassName());
        if (entry.isMultiRelease()) {
            return Transformer.ClassEntry.create(newName, entry.getTime(), data, entry.getVersion());
        }
        return Transformer.ClassEntry.create(newName + ".class", entry.getTime(), data);
    }

    @Override
    public Transformer.ResourceEntry process(Transformer.ResourceEntry entry) {
        if (ABSTRACT_FILE.equals(entry.getName())) {
            return null;
        }
        return entry;
    }

    @Override
    public Collection<? extends Transformer.Entry> getExtras() {
        if (this.abstractParams.isEmpty()) {
            return Collections.emptyList();
        }
        byte[] data = this.abstractParams.stream().sorted().collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8);
        return Arrays.asList(Transformer.ResourceEntry.create(ABSTRACT_FILE, 946684800L, data));
    }

    void storeNames(String className, String methodName, String methodDescriptor, Collection<String> paramNames) {
        this.abstractParams.add(className + ' ' + methodName + ' ' + methodDescriptor + ' ' + paramNames.stream().collect(Collectors.joining(" ")));
    }
}

