/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.fart.api.Inheritance;
import net.minecraftforge.fart.internal.Util;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class InheritanceImpl
implements Inheritance {
    private final Consumer<String> log;
    private Map<String, File> sources = new HashMap<String, File>();
    private Map<String, Optional<ClassInfo>> classes = new ConcurrentHashMap<String, Optional<ClassInfo>>();

    public InheritanceImpl(Consumer<String> log) {
        this.log = log;
    }

    @Override
    public void addLibrary(File path) {
        try (ZipFile jar = new ZipFile(path);){
            Util.forZip(jar, e -> {
                if (!e.getName().endsWith(".class") || e.getName().startsWith("META-INF")) {
                    return;
                }
                String name = e.getName();
                name = name.substring(0, name.length() - 6);
                this.sources.putIfAbsent(name, path);
            });
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Optional<? extends Inheritance.IClassInfo> getClass(String cls) {
        return this.classes.computeIfAbsent(cls, this::computeClassInfo);
    }

    @Override
    public void addClass(String name, byte[] value) {
        this.classes.computeIfAbsent(name, k -> Optional.of(new ClassInfo(value)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<ClassInfo> computeClassInfo(String name) {
        File source = this.sources.get(name);
        if (source != null) {
            try (ZipFile zf = new ZipFile(source);){
                ZipEntry entry = zf.getEntry(name + ".class");
                if (entry == null) {
                    throw new IllegalStateException("Could not get " + name + ".class entry in " + source.getAbsolutePath());
                }
                byte[] data = Util.toByteArray(zf.getInputStream(entry));
                Optional<ClassInfo> optional = Optional.of(new ClassInfo(data));
                return optional;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Class<?> cls = Class.forName(name.replace('/', '.'), false, this.getClass().getClassLoader());
            return Optional.of(new ClassInfo(cls));
        }
        catch (ClassNotFoundException ex) {
            this.log.accept("Cant Find Class: " + name);
            return Optional.empty();
        }
    }

    private static class Access {
        private static int[] ACC = new int[23];
        private static String[] NAME = new String[23];
        private final int value;
        private String toString;

        private static void put(int idx, int acc, String name) {
            Access.ACC[idx] = acc;
            Access.NAME[idx] = name;
        }

        public Access(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            if (this.toString == null) {
                ArrayList<String> ret = new ArrayList<String>();
                for (int x = 0; x < ACC.length; ++x) {
                    if ((this.value & ACC[x]) == 0) continue;
                    ret.add(NAME[x]);
                }
                this.toString = ret.isEmpty() ? "default" : ret.stream().collect(Collectors.joining(" "));
            }
            return this.toString;
        }

        static {
            int idx = 0;
            Access.put(idx++, 1, "public");
            Access.put(idx++, 2, "private");
            Access.put(idx++, 4, "protected");
            Access.put(idx++, 8, "static");
            Access.put(idx++, 16, "final");
            Access.put(idx++, 32, "super");
            Access.put(idx++, 32, "synchronized");
            Access.put(idx++, 32, "open");
            Access.put(idx++, 32, "transitive");
            Access.put(idx++, 64, "volatile");
            Access.put(idx++, 64, "bridge");
            Access.put(idx++, 64, "static_phase");
            Access.put(idx++, 128, "varargs");
            Access.put(idx++, 128, "transient");
            Access.put(idx++, 256, "native");
            Access.put(idx++, 512, "interface");
            Access.put(idx++, 1024, "abstract");
            Access.put(idx++, 2048, "strict");
            Access.put(idx++, 4096, "synthetic");
            Access.put(idx++, 8192, "annotation");
            Access.put(idx++, 16384, "enum");
            Access.put(idx++, 32768, "mandated");
            Access.put(idx++, 32768, "module");
        }
    }

    private static class ClassInfo
    implements Inheritance.IClassInfo {
        private final String name;
        private final Access access;
        private final String superName;
        private final List<String> interfaces;
        private final Map<String, FieldInfo> fields;
        private Collection<FieldInfo> fieldsView;
        private final Map<String, MethodInfo> methods;
        private Collection<MethodInfo> methodsView;

        ClassInfo(byte[] data) {
            ClassReader reader = new ClassReader(data);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 1);
            this.name = node.name;
            this.access = new Access(node.access);
            this.superName = node.superName;
            this.interfaces = node.interfaces.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(node.interfaces);
            this.methods = !node.methods.isEmpty() ? Collections.unmodifiableMap(node.methods.stream().map(x$0 -> new MethodInfo((MethodNode)x$0)).collect(Collectors.toMap(m -> m.getName() + m.getDescriptor(), Function.identity()))) : null;
            this.fields = !node.fields.isEmpty() ? Collections.unmodifiableMap(node.fields.stream().map(x$0 -> new FieldInfo((FieldNode)x$0)).collect(Collectors.toMap(FieldInfo::getName, Function.identity()))) : null;
        }

        ClassInfo(Class<?> node) {
            this.name = Util.nameToBytecode(node);
            this.access = new Access(node.getModifiers());
            this.superName = Util.nameToBytecode(node.getSuperclass());
            this.interfaces = Collections.unmodifiableList(Arrays.stream(node.getInterfaces()).map(c -> Util.nameToBytecode(c)).collect(Collectors.toList()));
            Map mtds = Stream.concat(Arrays.stream(node.getConstructors()).map(x$0 -> new MethodInfo((Constructor<?>)x$0)), Arrays.stream(node.getDeclaredMethods()).map(x$0 -> new MethodInfo((Method)x$0))).collect(Collectors.toMap(m -> m.getName() + m.getDescriptor(), Function.identity()));
            this.methods = mtds.isEmpty() ? null : Collections.unmodifiableMap(mtds);
            Field[] flds = node.getDeclaredFields();
            this.fields = flds != null && flds.length > 0 ? Collections.unmodifiableMap(Arrays.asList(flds).stream().map(x$0 -> new FieldInfo((Field)x$0)).collect(Collectors.toMap(FieldInfo::getName, Function.identity()))) : null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSuper() {
            return this.superName;
        }

        @Override
        public int getAccess() {
            return this.access.getValue();
        }

        public Access getAccessLevel() {
            return this.access;
        }

        @Override
        public Collection<String> getInterfaces() {
            return this.interfaces;
        }

        @Override
        public Collection<? extends Inheritance.IFieldInfo> getFields() {
            if (this.fieldsView == null) {
                this.fieldsView = this.fields == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.fields.values());
            }
            return this.fieldsView;
        }

        @Override
        public Optional<? extends Inheritance.IFieldInfo> getField(String name) {
            return this.fields == null ? Optional.empty() : Optional.ofNullable(this.fields.get(name));
        }

        @Override
        public Collection<? extends Inheritance.IMethodInfo> getMethods() {
            if (this.methodsView == null) {
                this.methodsView = this.methods == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.methods.values());
            }
            return this.methodsView;
        }

        @Override
        public Optional<? extends Inheritance.IMethodInfo> getMethod(String name, String desc) {
            return this.methods == null ? Optional.empty() : Optional.ofNullable(this.methods.get(name + " " + desc));
        }

        public String toString() {
            return this.getAccessLevel().toString() + ' ' + this.getName();
        }

        private class MethodInfo
        implements Inheritance.IMethodInfo {
            private final String name;
            private final String desc;
            private final Access access;

            MethodInfo(MethodNode node) {
                this.name = node.name;
                this.desc = node.desc;
                this.access = new Access(node.access);
            }

            MethodInfo(Method node) {
                this.name = node.getName();
                this.desc = Type.getMethodDescriptor((Method)node);
                this.access = new Access(node.getModifiers());
            }

            MethodInfo(Constructor<?> node) {
                this.name = "<init>";
                this.desc = Type.getConstructorDescriptor(node);
                this.access = new Access(node.getModifiers());
            }

            @Override
            public int getAccess() {
                return this.access.getValue();
            }

            public Access getAccessLevel() {
                return this.access;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getDescriptor() {
                return this.desc;
            }

            public String toString() {
                return this.getAccessLevel().toString() + ' ' + ClassInfo.this.getName() + '/' + this.getName() + this.getDescriptor();
            }
        }

        private class FieldInfo
        implements Inheritance.IFieldInfo {
            private final String name;
            private final String desc;
            private final Access access;

            public FieldInfo(FieldNode node) {
                this.name = node.name;
                this.desc = node.desc;
                this.access = new Access(node.access);
            }

            public FieldInfo(Field node) {
                this.name = node.getName();
                this.desc = Type.getType(node.getType()).getDescriptor();
                this.access = new Access(node.getModifiers());
            }

            @Override
            public int getAccess() {
                return this.access.getValue();
            }

            public Access getAccessLevel() {
                return this.access;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getDescriptor() {
                return this.desc;
            }

            public String toString() {
                return this.getAccessLevel().toString() + ' ' + ClassInfo.this.getName() + '/' + this.getName() + ' ' + this.getDescriptor();
            }
        }
    }
}

