/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.adaptors;

import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class InnerClassInitAdder
extends ClassVisitor {
    private static final Logger log = Logger.getLogger("MCInjector");
    private String className;
    private String parentName;
    private String parentField;
    private boolean hasInit = false;
    private boolean isStatic = false;
    private int FIELD_ACCESS = 4112;

    public InnerClassInitAdder(ClassVisitor cv) {
        super(393216, cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isStatic = (access & 8) != 0;
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.className.equals(name)) {
            this.parentName = "L" + outerName + ";";
        }
        super.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & this.FIELD_ACCESS) == this.FIELD_ACCESS && desc.equals(this.parentName)) {
            this.parentField = name;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name)) {
            this.hasInit = true;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (!this.hasInit && !this.isStatic && this.parentName != null && this.parentField != null) {
            log.fine("  Adding synthetic <init> " + this.parentName + " " + this.parentField);
            MethodVisitor mv = this.visitMethod(4098, "<init>", "(" + this.parentName + ")V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, this.className, this.parentField, this.parentName);
            mv.visitInsn(177);
        }
        super.visitEnd();
    }
}

