/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.adaptors;

import de.oceanlabs.mcp.mcinjector.MCInjector;
import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import de.oceanlabs.mcp.mcinjector.data.Constructors;
import de.oceanlabs.mcp.mcinjector.data.Exceptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class ApplyMap
extends ClassVisitor {
    String className;

    public ApplyMap(ClassVisitor cn) {
        super(393216, cn);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        if (name.equals("<clinit>")) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        exceptions = this.processExceptions(this.className, name, desc, exceptions);
        if ((access & 0x400) != 0 || (access & 0x100) != 0) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        return new MethodVisitor(this.api, this.cv.visitMethod(access, name, desc, signature, exceptions)){

            @Override
            public void visitEnd() {
                super.visitEnd();
                ApplyMap.this.processLVT(ApplyMap.this.className, name, desc, MCInjectorImpl.getMethodNode(this.mv));
            }
        };
    }

    private String[] processExceptions(String cls, String name, String desc, String[] exceptions) {
        HashSet<String> set = new HashSet<String>();
        for (String s : Exceptions.INSTANCE.getExceptions(cls, name, desc)) {
            set.add(s);
        }
        if (exceptions != null) {
            for (String s : exceptions) {
                set.add(s);
            }
        }
        if (set.size() > (exceptions == null ? 0 : exceptions.length)) {
            exceptions = (String[])set.stream().sorted().toArray(String[]::new);
            Exceptions.INSTANCE.setExceptions(cls, name, desc, exceptions);
            MCInjector.LOG.log(Level.FINE, "    Adding Exceptions: " + String.join((CharSequence)", ", exceptions));
        }
        return exceptions;
    }

    private void processLVT(String cls, String name, String desc, MethodNode mn) {
        int x;
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<Type> types = new ArrayList<Type>();
        if ((mn.access & 8) == 0) {
            types.add(Type.getType("L" + cls + ";"));
            params.add(0, "this");
        }
        types.addAll(Arrays.asList(Type.getArgumentTypes(mn.desc)));
        if (types.size() == 0) {
            return;
        }
        MCInjector.LOG.fine("    Generating map:");
        String nameFormat = "p_" + name + "_%d_";
        if (name.matches("func_\\d+_.+")) {
            nameFormat = "p_" + name.substring(5, name.indexOf(95, 5)) + "_%s_";
        } else if (name.equals("<init>")) {
            nameFormat = "p_i" + Constructors.INSTANCE.getID(this.className, desc, types.size() > 1) + "_%s_";
        }
        int y = x = params.size();
        while (x < types.size()) {
            String par_name = String.format(nameFormat, y);
            params.add(par_name);
            MCInjector.LOG.fine("      Naming argument " + x + " (" + y + ") -> " + par_name + " " + ((Type)types.get(x)).getDescriptor());
            y += ((Type)types.get(x)).getSize();
            ++x;
        }
        MCInjector.LOG.fine("    Applying map:");
        if (params.size() != types.size()) {
            MCInjector.LOG.log(Level.SEVERE, "    Incorrect argument count: " + types.size() + " -> " + params.size());
            throw new RuntimeException("Incorrect argument count: " + types.size() + " -> " + params.size());
        }
        AbstractInsnNode tmp = mn.instructions.getFirst();
        if (tmp == null) {
            mn.instructions.add(new LabelNode());
        } else if (tmp.getType() != 8) {
            mn.instructions.insertBefore(tmp, new LabelNode());
        }
        tmp = mn.instructions.getLast();
        if (tmp == null) {
            mn.instructions.add(new LabelNode());
        } else if (tmp.getType() != 8) {
            mn.instructions.insert(tmp, new LabelNode());
        }
        HashMap parNames = new HashMap();
        int y2 = 0;
        for (int x2 = 0; x2 < params.size(); ++x2) {
            parNames.put(y2, params.get(x2));
            y2 += ((Type)types.get(x2)).getSize();
        }
        LabelNode start = (LabelNode)mn.instructions.getFirst();
        LabelNode end = (LabelNode)mn.instructions.getLast();
        HashSet<Integer> found = new HashSet<Integer>();
        if (mn.localVariables == null) {
            mn.localVariables = new ArrayList<LocalVariableNode>();
        }
        for (LocalVariableNode lvn : mn.localVariables) {
            String par_name = (String)parNames.get(lvn.index);
            if (par_name == null) continue;
            MCInjector.LOG.fine("      ReNaming argument (" + lvn.index + "): " + lvn.name + " -> " + par_name);
            lvn.name = par_name;
            found.add(lvn.index);
        }
        int y3 = 0;
        for (int x3 = 0; x3 < params.size(); ++x3) {
            String arg = (String)params.get(x3);
            if (!found.contains(y3)) {
                MCInjector.LOG.fine("      Naming argument " + x3 + " (" + y3 + ") -> " + arg + " " + ((Type)types.get(x3)).getDescriptor());
                mn.localVariables.add(new LocalVariableNode(arg, ((Type)types.get(x3)).getDescriptor(), null, start, end, y3));
            }
            y3 += ((Type)types.get(x3)).getSize();
        }
        Collections.sort(mn.localVariables, (o1, o2) -> o1.index < o2.index ? -1 : (o1.index == o2.index ? 0 : 1));
    }
}

