/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.adaptors;

import de.oceanlabs.mcp.mcinjector.MCInjector;
import de.oceanlabs.mcp.mcinjector.data.Access;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class AccessFixer
extends ClassVisitor {
    private String className;

    public AccessFixer(ClassVisitor cv) {
        super(393216, cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        Access.Level old = Access.Level.getFromBytecode(access);
        Access.Level _new = Access.INSTANCE.getLevel(this.className);
        if (_new != null && old != _new) {
            MCInjector.LOG.info("  Access Change: " + (Object)((Object)old) + " -> " + (Object)((Object)_new) + " " + this.className);
            access = _new.setAccess(access);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Access.Level old = Access.Level.getFromBytecode(access);
        Access.Level _new = Access.INSTANCE.getLevel(this.className, name);
        if (_new != null && old != _new) {
            MCInjector.LOG.info("  Access Change: " + (Object)((Object)old) + " -> " + (Object)((Object)_new) + " " + this.className + " " + name);
            access = _new.setAccess(access);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Access.Level old = Access.Level.getFromBytecode(access);
        Access.Level _new = Access.INSTANCE.getLevel(this.className, name, desc);
        if (_new != null && old != _new) {
            MCInjector.LOG.info("  Access Change: " + (Object)((Object)old) + " -> " + (Object)((Object)_new) + " " + this.className + " " + name + " " + desc);
            access = _new.setAccess(access);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }
}

