/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector;

import de.oceanlabs.mcp.mcinjector.MCInjector;
import de.oceanlabs.mcp.mcinjector.adaptors.AccessFixer;
import de.oceanlabs.mcp.mcinjector.adaptors.ApplyMap;
import de.oceanlabs.mcp.mcinjector.adaptors.InnerClassInitAdder;
import de.oceanlabs.mcp.mcinjector.adaptors.ParameterAnnotationFixer;
import de.oceanlabs.mcp.mcinjector.data.Access;
import de.oceanlabs.mcp.mcinjector.data.Constructors;
import de.oceanlabs.mcp.mcinjector.data.Exceptions;
import de.oceanlabs.mcp.mcinjector.lvt.LVTFernflower;
import de.oceanlabs.mcp.mcinjector.lvt.LVTLvt;
import de.oceanlabs.mcp.mcinjector.lvt.LVTNaming;
import de.oceanlabs.mcp.mcinjector.lvt.LVTStrip;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MCInjectorImpl {
    public LVTNaming naming = LVTNaming.STRIP;
    private static Field field_mv;
    private static Field field_cv;

    static void process(Path in, Path out, Path accIn, Path accOut, Path ctrIn, Path ctrOut, Path excIn, Path excOut, LVTNaming naming) throws IOException {
        if (accIn != null) {
            Access.INSTANCE.load(accIn);
        }
        if (ctrIn != null) {
            Constructors.INSTANCE.load(ctrIn);
        }
        if (excIn != null) {
            Exceptions.INSTANCE.load(excIn);
        }
        MCInjector.LOG.info("Processing: " + in);
        MCInjector.LOG.info("  Output: " + out);
        MCInjectorImpl mci = new MCInjectorImpl();
        mci.naming = naming;
        mci.processJar(in, out);
        if (accOut != null) {
            Access.INSTANCE.dump(accOut);
        }
        if (ctrOut != null) {
            Constructors.INSTANCE.dump(ctrOut);
        }
        if (excOut != null) {
            Exceptions.INSTANCE.dump(excOut);
        }
        MCInjector.LOG.info("Processed " + in);
    }

    private MCInjectorImpl() {
    }

    private void processJar(Path inFile, Path outFile) throws IOException {
        try (ZipInputStream inJar = new ZipInputStream(Files.newInputStream(inFile, new OpenOption[0]));
             ZipOutputStream outJar = new ZipOutputStream(outFile == null ? new ByteArrayOutputStream() : Files.newOutputStream(outFile, StandardOpenOption.CREATE));){
            ZipEntry entry = inJar.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    outJar.putNextEntry(entry);
                } else {
                    int len;
                    byte[] data = new byte[4096];
                    ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
                    do {
                        if ((len = inJar.read(data)) <= 0) continue;
                        entryBuffer.write(data, 0, len);
                    } while (len != -1);
                    byte[] entryData = entryBuffer.toByteArray();
                    String entryName = entry.getName();
                    if (entryName.endsWith(".class") && entryName.startsWith("net/minecraft/")) {
                        MCInjector.LOG.log(Level.INFO, "Processing " + entryName);
                        entryData = this.processClass(entryData, outFile == null);
                        MCInjector.LOG.log(Level.INFO, "Processed " + entryBuffer.size() + " -> " + entryData.length);
                    } else {
                        MCInjector.LOG.log(Level.INFO, "Copying " + entryName);
                    }
                    ZipEntry newEntry = new ZipEntry(entryName);
                    outJar.putNextEntry(newEntry);
                    outJar.write(entryData);
                }
                entry = inJar.getNextEntry();
            }
        }
    }

    public byte[] processClass(byte[] cls, boolean readOnly) {
        ClassNode cn;
        ClassReader cr = new ClassReader(cls);
        ClassVisitor ca = cn = new ClassNode();
        if (!readOnly) {
            ca = new ApplyMap(ca);
            switch (this.naming) {
                case STRIP: {
                    ca = new LVTStrip(ca);
                    break;
                }
                case FERNFLOWER: {
                    ca = new LVTFernflower(ca);
                    break;
                }
                case LVT: {
                    ca = new LVTLvt(ca);
                }
            }
            ca = new AccessFixer(ca);
            ca = new ParameterAnnotationFixer(ca, this);
        }
        ca = new InnerClassInitAdder(ca);
        ca = new ClassVisitor(393216, ca){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                MCInjector.LOG.log(Level.FINE, "Class: " + name + " Extends: " + superName);
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MCInjector.LOG.log(Level.FINE, "  Name: " + name + " Desc: " + desc + " Sig: " + signature);
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        cr.accept(ca, 0);
        ClassWriter writer = new ClassWriter(1);
        cn.accept(writer);
        return writer.toByteArray();
    }

    public static MethodNode getMethodNode(MethodVisitor mv) {
        try {
            if (field_mv == null) {
                field_mv = MethodVisitor.class.getDeclaredField("mv");
                field_mv.setAccessible(true);
            }
            MethodVisitor tmp = mv;
            while (!(tmp instanceof MethodNode) && tmp != null) {
                tmp = (MethodVisitor)field_mv.get(tmp);
            }
            return (MethodNode)tmp;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static ClassNode getClassNode(ClassVisitor cv) {
        try {
            if (field_cv == null) {
                field_cv = ClassVisitor.class.getDeclaredField("cv");
                field_cv.setAccessible(true);
            }
            ClassVisitor tmp = cv;
            while (!(tmp instanceof ClassNode) && tmp != null) {
                tmp = (ClassVisitor)field_cv.get(tmp);
            }
            return (ClassNode)tmp;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

