/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector;

import de.oceanlabs.mcp.mcinjector.LogFormatter;
import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import de.oceanlabs.mcp.mcinjector.lvt.LVTNaming;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConverter;

public class MCInjector {
    public static final Logger LOG = Logger.getLogger("MCInjector");
    public static final String VERSION = "MCInjector v" + Optional.ofNullable(MCInjector.class.getPackage().getImplementationVersion()).orElse("Unknown") + " by Searge, LexManos, Fesh0r";
    private Path fileIn;
    private Path fileOut;
    private Path excIn;
    private Path excOut;
    private Path accIn;
    private Path accOut;
    private Path ctrIn;
    private Path ctrOut;
    private LVTNaming lvt;
    private static ValueConverter<Path> PATH_ARG = new ValueConverter<Path>(){

        @Override
        public Path convert(String value) {
            return Paths.get(value, new String[0]);
        }

        @Override
        public Class<Path> valueType() {
            return Path.class;
        }

        @Override
        public String valuePattern() {
            return null;
        }
    };

    public MCInjector(Path fileIn, Path fileOut) {
        this.fileIn = fileIn;
        this.fileOut = fileOut;
    }

    public MCInjector log(Path log) {
        if (log == null) {
            return this;
        }
        try {
            FileHandler filehandler = new FileHandler(log.toString());
            filehandler.setFormatter(new LogFormatter());
            LOG.addHandler(filehandler);
        }
        catch (IOException e) {
            System.out.println("Failed to setup logger: " + e.toString());
            e.printStackTrace();
        }
        return this;
    }

    public MCInjector log() {
        return this.log(System.out);
    }

    public MCInjector log(final PrintStream stream) {
        LOG.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                stream.println(String.format(record.getMessage(), record.getParameters()));
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        return this;
    }

    public MCInjector exceptions(Path exc) {
        this.excIn = exc;
        return this;
    }

    public MCInjector exceptionsOut(Path out) {
        this.excOut = out;
        return this;
    }

    public MCInjector access(Path acc) {
        this.accIn = acc;
        return this;
    }

    public MCInjector accessOut(Path out) {
        this.accOut = out;
        return this;
    }

    public MCInjector constructors(Path ctrs) {
        this.ctrIn = ctrs;
        return this;
    }

    public MCInjector constructorsOut(Path out) {
        this.ctrOut = out;
        return this;
    }

    public MCInjector lvt(LVTNaming lvt) {
        this.lvt = lvt;
        return this;
    }

    public void process() throws IOException {
        MCInjectorImpl.process(this.fileIn, this.fileOut, this.accIn, this.accOut, this.ctrIn, this.ctrOut, this.excIn, this.excOut, this.lvt);
    }

    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec help = parser.accepts("help").forHelp();
        AbstractOptionSpec ver = parser.accepts("version").forHelp();
        ArgumentAcceptingOptionSpec<Path> in = parser.accepts("in").withRequiredArg().withValuesConvertedBy(PATH_ARG).required();
        ArgumentAcceptingOptionSpec<Path> out = parser.accepts("out").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec<Path> log = parser.accepts("log").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec<Path> exc = parser.accepts("exc").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec<Path> excOut = parser.accepts("excOut").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec<Path> acc = parser.accepts("acc").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec<Path> accOut = parser.accepts("accOut").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec<Path> ctr = parser.accepts("ctr").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec<Path> ctrOut = parser.accepts("ctrOut").withRequiredArg().withValuesConvertedBy(PATH_ARG);
        ArgumentAcceptingOptionSpec<LVTNaming> lvt = parser.accepts("lvt").withRequiredArg().ofType(LVTNaming.class).defaultsTo(LVTNaming.STRIP, (LVTNaming[])new LVTNaming[0]);
        try {
            OptionSet o = parser.parse(args);
            if (o.has(help)) {
                System.out.println(VERSION);
                parser.printHelpOn(System.out);
                return;
            }
            if (o.has(ver)) {
                System.out.println(VERSION);
                return;
            }
            LOG.setUseParentHandlers(false);
            LOG.setLevel(Level.ALL);
            LOG.info(VERSION);
            LOG.info("Input:        " + o.valueOf(in));
            LOG.info("Output:       " + o.valueOf(out));
            LOG.info("Log:          " + o.valueOf(log));
            LOG.info("Exceptions:   " + o.valueOf(exc));
            LOG.info("              " + o.valueOf(excOut));
            LOG.info("Access:       " + o.valueOf(acc));
            LOG.info("              " + o.valueOf(accOut));
            LOG.info("Constructors: " + o.valueOf(ctr));
            LOG.info("              " + o.valueOf(ctrOut));
            LOG.info("LVT:          " + (Object)((Object)o.valueOf(lvt)));
            try {
                new MCInjector(o.valueOf(in), o.valueOf(out)).log().lvt(o.valueOf(lvt)).log(o.valueOf(log)).exceptions(o.valueOf(exc)).exceptionsOut(o.valueOf(excOut)).access(o.valueOf(acc)).accessOut(o.valueOf(accOut)).constructors(o.valueOf(ctr)).constructorsOut(o.valueOf(ctrOut)).process();
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e.getMessage());
                LOG.log(Level.SEVERE, "ERROR", e);
                e.printStackTrace();
                System.exit(1);
            }
        }
        catch (OptionException e) {
            parser.printHelpOn(System.out);
            e.printStackTrace();
        }
    }
}

