/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector;

import de.oceanlabs.mcp.mcinjector.LVTNaming;
import de.oceanlabs.mcp.mcinjector.LogFormatter;
import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import java.io.OutputStream;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class MCInjector {
    private static final Logger log = Logger.getLogger("MCInjector");
    public static final String VERSION = "MCInjector v3.2 by Searge, LexManos, Fesh0r";

    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        parser.accepts("help").forHelp();
        parser.accepts("version").forHelp();
        parser.accepts("jarIn").withRequiredArg().required();
        parser.accepts("jarOut").withRequiredArg();
        parser.accepts("mapIn").withRequiredArg().required();
        parser.accepts("mapOut").withRequiredArg();
        parser.accepts("log").withRequiredArg();
        parser.accepts("index").withRequiredArg().ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]);
        parser.accepts("jsonIn").withRequiredArg();
        parser.accepts("applyMarkers");
        parser.accepts("generateParams");
        parser.accepts("lvt").withRequiredArg().ofType(LVTNaming.class).defaultsTo((Object)LVTNaming.STRIP, (Object[])new LVTNaming[0]);
        try {
            OptionSet options = parser.parse(args);
            if (options.has("help")) {
                System.out.println(VERSION);
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            if (options.has("version")) {
                System.out.println(VERSION);
                return;
            }
            String jarIn = (String)options.valueOf("jarIn");
            String jarOut = (String)options.valueOf("jarOut");
            String mapIn = (String)options.valueOf("mapIn");
            String mapOut = (String)options.valueOf("mapOut");
            String log = (String)options.valueOf("log");
            String jsonIn = (String)options.valueOf("jsonIn");
            int index = (Integer)options.valueOf("index");
            boolean applyM = options.has("applyMarkers");
            boolean genArgs = options.has("generateParams");
            LVTNaming naming = (LVTNaming)((Object)options.valueOf("lvt"));
            MCInjector.log.setUseParentHandlers(false);
            MCInjector.log.setLevel(Level.ALL);
            if (log != null) {
                FileHandler filehandler = new FileHandler(log);
                filehandler.setFormatter(new LogFormatter());
                MCInjector.log.addHandler(filehandler);
                MCInjector.log.addHandler(new Handler(){

                    @Override
                    public void publish(LogRecord record) {
                        System.out.println(String.format(record.getMessage(), record.getParameters()));
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void close() throws SecurityException {
                    }
                });
            }
            MCInjector.log(VERSION);
            MCInjector.log("Input:          " + jarIn);
            MCInjector.log("Output:         " + jarOut);
            MCInjector.log("Log:            " + log);
            MCInjector.log("MappingsInput:  " + mapIn);
            MCInjector.log("MappingsOutput: " + mapOut);
            MCInjector.log("Mappings:       " + index);
            MCInjector.log("Json:           " + jsonIn);
            MCInjector.log("ApplyMarker:    " + applyM);
            MCInjector.log("GenArgs:        " + genArgs);
            MCInjector.log("LVT:            " + (Object)((Object)naming));
            try {
                MCInjectorImpl.process(jarIn, jarOut, mapIn, log, mapOut, index, jsonIn, applyM, genArgs, naming);
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e.getMessage());
                MCInjector.log.log(Level.SEVERE, "ERROR", e);
                e.printStackTrace();
                System.exit(1);
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    private static void log(String line) {
        log.info(line);
    }
}

