/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.adaptors;

import de.oceanlabs.mcp.mcinjector.JsonStruct;
import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JsonAttribute
extends ClassVisitor {
    private static final Logger log = Logger.getLogger("MCInjector");
    private MCInjectorImpl mci;
    private String className;
    private JsonStruct json;
    private boolean visitedOuter = false;
    private Set<String> visitedInners = new HashSet<String>();
    private Set<String> refedInners = new HashSet<String>();

    public JsonAttribute(ClassVisitor cv, MCInjectorImpl mci) {
        super(327680, cv);
        this.mci = mci;
    }

    private String getAccess(int access) {
        StringBuilder buf = new StringBuilder();
        if ((access & 1) != 0) {
            buf.append("PUBLIC ");
        } else if ((access & 2) != 0) {
            buf.append("PRIVATE ");
        } else if ((access & 4) != 0) {
            buf.append("PROTECTED ");
        } else {
            buf.append("DEFAULT ");
        }
        if ((access & 0x10) != 0) {
            buf.append("FINAL ");
        }
        if ((access & 0x20) != 0) {
            buf.append("SUPER ");
        }
        if ((access & 0x200) != 0) {
            buf.append("INTERFACE ");
        }
        if ((access & 0x400) != 0) {
            buf.append("ABSTRACT ");
        }
        if ((access & 0x1000) != 0) {
            buf.append("SYNTHETIC ");
        }
        if ((access & 0x2000) != 0) {
            buf.append("ANNOTATION ");
        }
        if ((access & 0x4000) != 0) {
            buf.append("ENUM ");
        }
        return buf.toString().trim();
    }

    private boolean isInnerClass(String name) {
        return name.contains("$");
    }

    private void referenced(Type type) {
        String internal;
        if (type.getSort() == 9) {
            type = type.getElementType();
        }
        if (type.getSort() == 10 && this.isInnerClass(internal = type.getInternalName())) {
            this.refedInners.add(internal);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.json = this.mci.json.get(this.className);
        this.visitedOuter = false;
        this.visitedInners.clear();
        for (String i : interfaces) {
            if (!this.isInnerClass(i)) continue;
            this.refedInners.add(i);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.referenced(Type.getType((String)desc));
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (exceptions != null) {
            for (String string : exceptions) {
                if (!this.isInnerClass(string)) continue;
                this.refedInners.add(string);
            }
        }
        this.referenced(Type.getReturnType((String)desc));
        for (String string : Type.getArgumentTypes((String)desc)) {
            this.referenced((Type)string);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.visitedInners.add(name);
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.visitedOuter = true;
        super.visitOuterClass(owner, name, desc);
    }

    public void visitEnd() {
        if (this.json == null) {
            super.visitEnd();
            return;
        }
        JsonStruct.EnclosingMethod enc = this.json.enclosingMethod;
        if (enc != null && !this.visitedOuter && enc.name != null && enc.desc != null) {
            log.fine("  Adding Outer Class:");
            log.fine("    Owner: " + enc.owner);
            log.fine("    Method: " + enc.name + enc.desc);
            super.visitOuterClass(enc.owner, enc.name, enc.desc);
        }
        if (this.json.innerClasses != null) {
            for (JsonStruct.InnerClass innerClass : this.json.innerClasses) {
                if (this.visitedInners.contains(innerClass.inner_class)) continue;
                this.visitedInners.add(innerClass.inner_class);
                log.fine("  Adding Inner Class:");
                log.fine("    Inner: " + innerClass.inner_class);
                log.fine("    Access: " + this.getAccess(innerClass.getAccess()));
                if (innerClass.outer_class != null) {
                    log.fine("    Outer: " + innerClass.outer_class);
                }
                if (innerClass.inner_name != null) {
                    log.fine("    Name: " + innerClass.inner_name);
                }
                super.visitInnerClass(innerClass.inner_class, innerClass.outer_class, innerClass.inner_name, innerClass.getAccess());
            }
        }
        this.refedInners.removeAll(this.visitedInners);
        for (String string : this.refedInners) {
            JsonStruct.InnerClass ic = this.mci.inners.get(string);
            if (ic == null) {
                log.fine("  Referenced Inner Class: " + string + " (missing)");
                continue;
            }
            log.fine("  Referenced Inner Class:");
            log.fine("    Inner: " + ic.inner_class);
            log.fine("    Access: " + this.getAccess(ic.getAccess()));
            if (ic.outer_class != null) {
                log.fine("    Outer: " + ic.outer_class);
            }
            if (ic.inner_name == null) continue;
            log.fine("    Name: " + ic.inner_name);
        }
    }
}

