/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.adaptors;

import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class AccessReader
extends ClassVisitor {
    private static final Logger log = Logger.getLogger("MCInjector");
    private String className;
    private Map<String, AccessInfo> methods = new HashMap<String, AccessInfo>();

    public AccessReader(ClassVisitor cv, MCInjectorImpl mci) {
        super(327680, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor ret = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.className.startsWith("net/minecraft/") && name.startsWith("access$")) {
            String path = this.className + "/" + name + desc;
            final AccessInfo info = new AccessInfo(this.className, name, desc);
            info.access = access;
            this.methods.put(path, info);
            ret = new MethodVisitor(this.api, ret){

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    info.add(opcode, owner, name, desc);
                    super.visitFieldInsn(opcode, owner, name, desc);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    info.add(opcode, owner, name, desc);
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            };
        }
        return ret;
    }

    public void visitEnd() {
        super.visitEnd();
        for (Map.Entry<String, AccessInfo> entry : this.methods.entrySet()) {
            log.log(Level.FINE, "Access: " + entry.getKey() + " " + entry.getValue());
        }
    }

    private static class AccessInfo {
        public String owner;
        public String name;
        public String desc;
        public int access;
        public List<Insn> insns = new ArrayList<Insn>();

        public AccessInfo(String owner, String name, String desc) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        public void add(int opcode, String owner, String name, String desc) {
            this.insns.add(new Insn(opcode, owner, name, desc));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append('[').append(this.insns.get(0));
            for (int x = 1; x < this.insns.size(); ++x) {
                buf.append(", ").append(this.insns.get(x));
            }
            buf.append(']');
            return buf.toString();
        }

        public boolean targetEquals(AccessInfo o) {
            return this.toString().equals(o.toString());
        }

        public static class Insn {
            public int opcode;
            public String target_owner;
            public String target_name;
            public String target_desc;

            Insn(int opcode, String owner, String name, String desc) {
                this.opcode = opcode;
                this.target_owner = owner;
                this.target_name = name;
                this.target_desc = desc;
            }

            public String toString() {
                String op = "UNKNOWN_" + this.opcode;
                switch (this.opcode) {
                    case 178: {
                        op = "GETSTATIC";
                        break;
                    }
                    case 179: {
                        op = "PUTSTATIC";
                        break;
                    }
                    case 180: {
                        op = "GETFIELD";
                        break;
                    }
                    case 181: {
                        op = "PUTFIELD";
                        break;
                    }
                    case 182: {
                        op = "INVOKEVIRTUAL";
                        break;
                    }
                    case 183: {
                        op = "INVOKESPECIAL";
                        break;
                    }
                    case 184: {
                        op = "INVOKESTATIC";
                        break;
                    }
                    case 185: {
                        op = "INVOKEINTERFACE";
                    }
                }
                return op + " " + this.target_owner + "/" + this.target_name + " " + this.target_desc;
            }
        }
    }
}

