/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.adaptors;

import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import de.oceanlabs.mcp.mcinjector.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class ApplyMap
extends ClassVisitor {
    private static final Logger log = Logger.getLogger("MCInjector");
    private MCInjectorImpl mci;
    String className;
    private ClassNode cn;

    public ApplyMap(ClassNode cn, MCInjectorImpl mci) {
        super(262144, (ClassVisitor)cn);
        this.mci = mci;
        this.cn = cn;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (!this.mci.generate) {
            log.log(Level.FINE, "Class: " + name + " Extends: " + superName);
        }
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("<clinit>")) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (!this.mci.generate) {
            log.log(Level.FINER, "  Name: " + name + " Desc: " + desc + " Sig: " + signature);
        }
        String clsSig = this.className + "." + name + desc;
        exceptions = this.processExceptions(clsSig, exceptions);
        if ((access & 0x400) != 0 || (access & 0x100) != 0) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        MethodNode mn = (MethodNode)this.cn.visitMethod(access, name, desc, signature, exceptions);
        mn = this.processLVT(this.className, clsSig, mn);
        return mn;
    }

    private String[] processExceptions(String clsSig, String[] exceptions) {
        List<String> map = this.mci.getExceptions(clsSig);
        if (exceptions != null) {
            for (String s : exceptions) {
                if (map.contains(s)) continue;
                map.add(s);
            }
        }
        if (map.size() > 0) {
            String excs = StringUtil.joinString(map, ",");
            exceptions = map.toArray(new String[map.size()]);
            log.log(Level.FINE, "    Adding Exceptions: " + excs);
            this.mci.setExceptions(clsSig, excs);
        }
        return exceptions;
    }

    private MethodNode processLVT(String clsName, String classSig, MethodNode mn) {
        int x;
        List<String> params = this.mci.getParams(classSig);
        if (params.size() == 0) {
            return mn;
        }
        ArrayList<Type> types = new ArrayList<Type>();
        if ((mn.access & 8) == 0) {
            types.add(Type.getType((String)("L" + clsName + ";")));
            params.add(0, "this");
        }
        types.addAll(Arrays.asList(Type.getArgumentTypes((String)mn.desc)));
        if (types.size() == 0) {
            return mn;
        }
        log.fine("    Applying map:");
        if (params.size() != types.size()) {
            log.log(Level.SEVERE, "    Incorrect argument count: " + types.size() + " -> " + params.size());
            throw new RuntimeException("Incorrect argument count: " + types.size() + " -> " + params.size());
        }
        AbstractInsnNode tmp = mn.instructions.getFirst();
        if (tmp == null) {
            mn.instructions.add((AbstractInsnNode)new LabelNode());
        } else if (tmp.getType() != 8) {
            mn.instructions.insertBefore(tmp, (AbstractInsnNode)new LabelNode());
        }
        tmp = mn.instructions.getLast();
        if (tmp == null) {
            mn.instructions.add((AbstractInsnNode)new LabelNode());
        } else if (tmp.getType() != 8) {
            mn.instructions.insert(tmp, (AbstractInsnNode)new LabelNode());
        }
        LabelNode start = (LabelNode)mn.instructions.getFirst();
        LabelNode end = (LabelNode)mn.instructions.getLast();
        mn.localVariables = new ArrayList();
        int y = x = 0;
        while (x < params.size()) {
            String arg = params.get(x);
            String desc = ((Type)types.get(x)).getDescriptor();
            if (arg.equals("")) {
                log.fine("      Skipping argument " + x + " (" + y + ") -> " + desc);
            } else {
                log.fine("      Naming argument " + x + " (" + y + ") -> " + arg + " " + desc);
                mn.localVariables.add(new LocalVariableNode(arg, desc, null, start, end, y));
            }
            if (desc.equals("J") || desc.equals("D")) {
                ++y;
            }
            ++x;
            ++y;
        }
        return mn;
    }
}

