/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.oceanlabs.mcp.mcinjector.AccessFixerClassAdaptor;
import de.oceanlabs.mcp.mcinjector.AccessReaderClassAdaptor;
import de.oceanlabs.mcp.mcinjector.ApplyMapClassAdapter;
import de.oceanlabs.mcp.mcinjector.ApplyMarkerClassAdaptor;
import de.oceanlabs.mcp.mcinjector.GenerateMapClassAdapter;
import de.oceanlabs.mcp.mcinjector.InheratanceMap;
import de.oceanlabs.mcp.mcinjector.JsonAttributeClassAdaptor;
import de.oceanlabs.mcp.mcinjector.JsonStruct;
import de.oceanlabs.mcp.mcinjector.ReadMarkerClassAdaptor;
import de.oceanlabs.mcp.mcinjector.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class MCInjectorImpl {
    private static final Logger log = Logger.getLogger("MCInjector");
    public final Map<String, JsonStruct> json = new HashMap<String, JsonStruct>();
    public final Map<String, JsonStruct.InnerClass> inners = new HashMap<String, JsonStruct.InnerClass>();
    public final Properties mappings = new Properties();
    public final Properties outMappings = new Properties(){
        private static final long serialVersionUID = 4112578634029874840L;

        @Override
        public synchronized Enumeration keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<Object> keyList = new Vector<Object>();
            while (keysEnum.hasMoreElements()) {
                keyList.add(keysEnum.nextElement());
            }
            Collections.sort(keyList);
            return keyList.elements();
        }
    };
    public int initIndex = 0;
    private int classIDIndex = 0;
    public boolean generate = false;
    private boolean applyMarkers = false;
    public final InheratanceMap inheratance;
    public boolean genParams = false;
    private static final Gson GSON = new Gson();

    public static void process(String inFile, String outFile, String mapFile, String logFile, String outMapFile, int index, String classJson, boolean applyMarkers) throws IOException {
        MCInjectorImpl.process(inFile, outFile, mapFile, logFile, outMapFile, index, classJson, applyMarkers, false);
    }

    public static void process(String inFile, String outFile, String mapFile, String logFile, String outMapFile, int index, String classJson, boolean applyMarkers, boolean genParams) throws IOException {
        MCInjectorImpl mci = new MCInjectorImpl(index, outMapFile != null);
        mci.loadJson(classJson);
        mci.loadMap(mapFile);
        mci.applyMarkers = applyMarkers;
        mci.genParams = genParams;
        mci.processJar(inFile, outFile);
        if (outMapFile != null) {
            mci.saveMap(outMapFile);
        }
        log.info("Processed " + inFile);
    }

    private MCInjectorImpl(int index, boolean generate) {
        this.initIndex = index;
        this.generate = generate;
        this.inheratance = generate ? new InheratanceMap() : null;
    }

    public void loadMap(String mapFile) throws IOException {
        FileReader mapReader = null;
        try {
            int idx;
            String value;
            String key;
            mapReader = new FileReader(mapFile);
            this.mappings.load(mapReader);
            if (this.initIndex == 0 && this.generate) {
                HashMap<Integer, String> usedIds = new HashMap<Integer, String>();
                Iterator<Object> itr = this.mappings.keySet().iterator();
                while (itr.hasNext()) {
                    key = (String)itr.next();
                    value = this.mappings.getProperty(key);
                    if (!key.contains("<init>") || !value.contains("|p_i")) continue;
                    value = StringUtil.splitString(value, "|").get(1);
                    value = StringUtil.splitString(value, ",").get(0);
                    idx = Integer.parseInt((value = StringUtil.splitString(value, "_").get(1)).substring(1));
                    if (idx > this.initIndex) {
                        this.initIndex = idx;
                    }
                    if (usedIds.containsKey(idx)) {
                        log.warning("Duplicate constructor ID mapping: " + idx + " " + (String)usedIds.get(idx) + " " + key);
                        itr.remove();
                        continue;
                    }
                    usedIds.put(idx, key);
                }
                log.info("Loaded Max Constructor Index: " + ++this.initIndex);
            }
            if (this.generate) {
                this.fixExceptions(this.mappings);
            }
            for (Object o : this.mappings.keySet()) {
                key = (String)o;
                value = this.mappings.getProperty(key);
                if (key.indexOf(46) != -1 || !value.startsWith("CL_") || (idx = Integer.parseInt(value.substring(3))) <= this.classIDIndex) continue;
                this.classIDIndex = idx;
            }
            log.info("Loaded max Class Index: " + ++this.classIDIndex);
        }
        catch (IOException e) {
            throw new IOException("Could not open map file: " + e.getMessage());
        }
        finally {
            if (mapReader != null) {
                try {
                    ((Reader)mapReader).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void loadJson(String classJson) throws IOException {
        if (classJson == null) {
            return;
        }
        FileReader reader = null;
        try {
            reader = new FileReader(classJson);
            this.json.clear();
            JsonObject object = (JsonObject)new JsonParser().parse(reader);
            block9: for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
                String name = entry.getKey();
                JsonStruct struct = GSON.fromJson(entry.getValue(), JsonStruct.class);
                this.json.put(name, struct);
                if (!name.contains("$") || struct.innerClasses == null) continue;
                for (JsonStruct.InnerClass ic : struct.innerClasses) {
                    if (!name.equals(ic.inner_class)) continue;
                    this.inners.put(name, ic);
                    continue block9;
                }
            }
        }
        catch (IOException e) {
            throw new IOException("Could not open json file: " + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void fixExceptions(Properties props) {
        class Method {
            public String cls;
            public String desc;

            Method(String cls, String desc) {
                this.cls = cls;
                this.desc = desc;
            }
        }
        class Line {
            public String name;
            public List<Method> classes = new ArrayList<Method>();
            public List<String> exceptions = new ArrayList<String>();

            Line() {
            }
        }
        HashMap<String, Line> entries = new HashMap<String, Line>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value.indexOf(124) == -1) continue;
            String cls = key.split("\\.")[0];
            String name = key.split("\\.")[1];
            String desc = name.substring(name.indexOf(40));
            if (!(name = name.substring(0, name.indexOf(40))).startsWith("func_")) continue;
            Line line = (Line)entries.get(name);
            if (line == null) {
                line = new Line();
                line.name = name;
                entries.put(name, line);
            }
            line.classes.add(new Method(cls, desc));
            value = StringUtil.splitString(value, "|", -1).get(0);
            for (String exc : StringUtil.splitString(value, ",", -1)) {
                if ("".equals(exc) || line.exceptions.contains(exc)) continue;
                line.exceptions.add(exc);
            }
        }
        for (Map.Entry<Object, Object> entry : entries.entrySet()) {
            Line line = (Line)entry.getValue();
            String excs = StringUtil.joinString(line.exceptions, ",", -1);
            for (Method m : line.classes) {
                String key = m.cls + "." + line.name + m.desc;
                List<String> old = StringUtil.splitString(props.getProperty(key), "|", -1);
                if (excs.equals(old.get(0))) continue;
                props.setProperty(key, excs + "|" + old.get(1));
                log.info("Fixed Exception: " + key + ": " + old.get(0) + " -> " + excs);
            }
        }
    }

    private void filterMap(Properties map) {
        Iterator<Map.Entry<Object, Object>> itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> entry = itr.next();
            String value = (String)entry.getValue();
            if (value.indexOf(124) < 0 || !"|".equals(value)) continue;
            itr.remove();
        }
    }

    public void saveMap(String mapFile) throws IOException {
        Writer mapWriter = null;
        try {
            if (this.generate) {
                this.fixExceptions(this.outMappings);
            }
            this.filterMap(this.outMappings);
            mapWriter = new FileWriter(mapFile);
            if (this.initIndex > 0) {
                this.outMappings.put("max_constructor_index", Integer.toString(this.initIndex));
                this.outMappings.store(mapWriter, "max index=" + this.initIndex);
            } else {
                this.outMappings.store(mapWriter, null);
            }
        }
        catch (IOException e) {
            throw new IOException("Could not write map file: " + e.getMessage());
        }
        finally {
            if (mapWriter != null) {
                try {
                    mapWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getMarker(String cls) {
        String marker = this.mappings.getProperty(cls);
        if (marker == null) {
            if (!this.generate) {
                return null;
            }
            marker = String.format("CL_%08d", this.classIDIndex++);
        }
        this.outMappings.put(cls, marker);
        return marker;
    }

    public List<String> getExceptions(String signature) {
        String curMap = this.mappings.getProperty(signature);
        if (curMap == null) {
            return new ArrayList<String>();
        }
        List<String> splitMap = StringUtil.splitString(curMap, "|", -1);
        String exceptions = splitMap.get(0).replace('.', '/');
        if (exceptions.equals("")) {
            return new ArrayList<String>();
        }
        return StringUtil.splitString(exceptions, ",");
    }

    public List<String> getParams(String signature) {
        String curMap = this.mappings.getProperty(signature);
        if (curMap == null) {
            return new ArrayList<String>();
        }
        List<String> split = StringUtil.splitString(curMap, "|", -1);
        if (split.size() <= 1 || split.get(1).equals("")) {
            return new ArrayList<String>();
        }
        return StringUtil.splitString(split.get(1), ",");
    }

    public void setExceptions(String signature, String excs) {
        String curMap = this.outMappings.getProperty(signature);
        if (curMap == null) {
            curMap = excs + "|";
        }
        List<String> splitMap = StringUtil.splitString(curMap, "|", -1);
        this.outMappings.put(signature, excs + "|" + splitMap.get(1));
    }

    public void setParams(String signature, String params) {
        String curMap = this.outMappings.getProperty(signature);
        if (curMap == null) {
            curMap = "|" + params;
        }
        List<String> splitMap = StringUtil.splitString(curMap, "|", -1);
        if (!this.genParams || signature.contains("<")) {
            this.outMappings.put(signature, splitMap.get(0) + "|" + params);
        } else {
            this.outMappings.put(signature, splitMap.get(0) + "|");
        }
        curMap = this.mappings.getProperty(signature);
        if (curMap == null) {
            curMap = "|" + params;
        }
        splitMap = StringUtil.splitString(curMap, "|", -1);
        this.mappings.put(signature, splitMap.get(0) + "|" + params);
    }

    public void setAccess(String signature, InheratanceMap.Access access) {
        this.outMappings.put(signature + "-Access", access.toString());
    }

    public InheratanceMap.Access getAccess(String signature) {
        String ent = this.mappings.getProperty(signature + "-Access");
        if (ent == null) {
            return null;
        }
        return InheratanceMap.Access.valueOf(ent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processJar(String inFile, String outFile) throws IOException {
        if (this.inheratance != null) {
            this.gatherInheratance(inFile);
        }
        ZipInputStream inJar = null;
        ZipOutputStream outJar = null;
        try {
            ZipEntry entry;
            try {
                inJar = new ZipInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open input file: " + e.getMessage());
            }
            try {
                OutputStream out = outFile == null ? new ByteArrayOutputStream() : new FileOutputStream(outFile);
                outJar = new ZipOutputStream(new BufferedOutputStream(out));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open output file: " + e.getMessage());
            }
            while ((entry = inJar.getNextEntry()) != null) {
                int len;
                if (entry.isDirectory()) {
                    outJar.putNextEntry(entry);
                    continue;
                }
                byte[] data = new byte[4096];
                ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
                do {
                    if ((len = inJar.read(data)) <= 0) continue;
                    entryBuffer.write(data, 0, len);
                } while (len != -1);
                byte[] entryData = entryBuffer.toByteArray();
                String entryName = entry.getName();
                if (entryName.endsWith(".class") && entryName.startsWith("net/minecraft/")) {
                    log.log(Level.INFO, "Processing " + entryName);
                    entryData = this.processClass(entryData, outFile == null);
                    log.log(Level.INFO, "Processed " + entryBuffer.size() + " -> " + entryData.length);
                } else {
                    log.log(Level.INFO, "Copying " + entryName);
                }
                ZipEntry newEntry = new ZipEntry(entryName);
                outJar.putNextEntry(newEntry);
                outJar.write(entryData);
            }
        }
        finally {
            if (outJar != null) {
                try {
                    outJar.close();
                }
                catch (IOException e) {}
            }
            if (inJar != null) {
                try {
                    inJar.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherInheratance(String inFile) throws IOException {
        ZipInputStream inJar = null;
        try {
            ZipEntry entry;
            try {
                inJar = new ZipInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open input file: " + e.getMessage());
            }
            while ((entry = inJar.getNextEntry()) != null) {
                int len;
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                byte[] data = new byte[4096];
                ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
                do {
                    if ((len = inJar.read(data)) <= 0) continue;
                    entryBuffer.write(data, 0, len);
                } while (len != -1);
                this.inheratance.processClass(entryBuffer.toByteArray());
            }
        }
        finally {
            if (inJar != null) {
                try {
                    inJar.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public byte[] processClass(byte[] cls, boolean readOnly) {
        ClassNode cn;
        ClassReader cr = new ClassReader(cls);
        ClassVisitor ca = cn = new ClassNode();
        if (readOnly) {
            ca = new ReadMarkerClassAdaptor(ca, this);
        } else {
            ca = new ApplyMapClassAdapter(cn, this);
            ca = new JsonAttributeClassAdaptor(ca, this);
            if (this.applyMarkers) {
                ca = new ApplyMarkerClassAdaptor(ca, this);
            }
            if (this.generate || this.genParams) {
                ca = new GenerateMapClassAdapter(ca, this);
            }
            ca = new AccessFixerClassAdaptor(ca, this);
        }
        ca = new AccessReaderClassAdaptor(ca, this);
        cr.accept(ca, 0);
        ClassWriter writer = new ClassWriter(1);
        cn.accept(writer);
        return writer.toByteArray();
    }
}

