/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.niofs.union;

import cpw.mods.niofs.union.UnionFileSystemProvider;
import cpw.mods.niofs.union.UnionPath;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;

public class UnionFileSystem
extends FileSystem {
    private static final MethodHandle ZIPFS_EXISTS;
    private static final MethodHandle ZIPFS_CH;
    private static final MethodHandle FCI_UNINTERUPTIBLE;
    static final String SEP_STRING = "/";
    private final UnionPath root = new UnionPath(this, "/");
    private final UnionFileSystemProvider provider;
    private final String key;
    private final List<Path> basepaths;
    private final int lastElementIndex;
    @Nullable
    private final BiPredicate<String, String> pathFilter;
    private final Map<Path, EmbeddedFileSystemMetadata> embeddedFileSystems;

    public InputStream buildInputStream(UnionPath path) {
        try {
            byte[] bytes = Files.readAllBytes(path);
            return new ByteArrayInputStream(bytes);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public Path getPrimaryPath() {
        return this.basepaths.get(this.basepaths.size() - 1);
    }

    @Nullable
    public BiPredicate<String, String> getFilesystemFilter() {
        return this.pathFilter;
    }

    String getKey() {
        return this.key;
    }

    public UnionFileSystem(UnionFileSystemProvider provider, @Nullable BiPredicate<String, String> pathFilter, String key, Path ... basepaths) {
        this.pathFilter = pathFilter;
        this.provider = provider;
        this.key = key;
        this.basepaths = IntStream.range(0, basepaths.length).mapToObj(i -> basepaths[basepaths.length - i - 1]).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toList();
        this.lastElementIndex = basepaths.length - 1;
        this.embeddedFileSystems = this.basepaths.stream().filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(UnionFileSystem::openFileSystem).flatMap(Optional::stream).collect(Collectors.toMap(EmbeddedFileSystemMetadata::path, Function.identity()));
    }

    private static Optional<EmbeddedFileSystemMetadata> openFileSystem(Path path) {
        try {
            FileSystem zfs = FileSystems.newFileSystem(path);
            SeekableByteChannel fci = ZIPFS_CH.invoke(zfs);
            if (fci instanceof FileChannel) {
                FCI_UNINTERUPTIBLE.invoke(fci);
            }
            return Optional.of(new EmbeddedFileSystemMetadata(path, zfs, fci));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    @Override
    public UnionFileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() {
        this.provider().removeFileSystem(this);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getSeparator() {
        return SEP_STRING;
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singletonList(this.root);
    }

    public Path getRoot() {
        return this.root;
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections::emptyIterator;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Set.of("basic");
    }

    @Override
    public Path getPath(String first, String ... more) {
        if (more.length > 0) {
            String[] args = new String[more.length + 1];
            args[0] = first;
            System.arraycopy(more, 0, args, 1, more.length);
            return new UnionPath(this, args);
        }
        return new UnionPath(this, first);
    }

    private Path fastPath(String ... parts) {
        return new UnionPath(this, false, parts);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    List<Path> getBasePaths() {
        return this.basepaths;
    }

    private Optional<BasicFileAttributes> getFileAttributes(Path path) {
        try {
            Boolean fastCheck = UnionFileSystem.tryFastPathExists(this, path);
            if (fastCheck != null && !fastCheck.booleanValue()) {
                return Optional.empty();
            }
            return Optional.of(path.getFileSystem().provider().readAttributes(path, BasicFileAttributes.class, new LinkOption[0]));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private static boolean fastPathExists(UnionFileSystem ufs, Path path) {
        Boolean result = UnionFileSystem.tryFastPathExists(ufs, path);
        return result != null ? result : Files.exists(path, new LinkOption[0]);
    }

    @Nullable
    private static Boolean tryFastPathExists(UnionFileSystem ufs, Path path) {
        if (path.getFileSystem() == FileSystems.getDefault()) {
            return path.toFile().exists();
        }
        if (path.getFileSystem().provider().getScheme().equals("jar")) {
            return UnionFileSystem.zipFsExists(ufs, path);
        }
        return null;
    }

    private static boolean zipFsExists(UnionFileSystem ufs, Path path) {
        try {
            if (Optional.ofNullable(ufs.embeddedFileSystems.get(path.getFileSystem())).filter(efs -> !efs.fsCh.isOpen()).isPresent()) {
                throw new IllegalStateException("The zip file has closed!");
            }
            return ZIPFS_EXISTS.invoke(path);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    private Optional<Path> findFirstFiltered(UnionPath unionPath) {
        Path last;
        Path realPath;
        for (int i = 0; i < this.lastElementIndex; ++i) {
            Path p = this.basepaths.get(i);
            Path realPath2 = this.toRealPath(p, unionPath);
            if (!this.testFilter(realPath2, p) || !UnionFileSystem.fastPathExists(this, realPath2)) continue;
            return Optional.of(realPath2);
        }
        if (this.lastElementIndex >= 0 && this.testFilter(realPath = this.toRealPath(last = this.basepaths.get(this.lastElementIndex), unionPath), last)) {
            return Optional.of(realPath);
        }
        return Optional.empty();
    }

    public <A extends BasicFileAttributes> A readAttributes(UnionPath path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class) {
            for (Path base : this.basepaths) {
                Path realPath = this.toRealPath(base, path);
                Optional<BasicFileAttributes> fileAttributes = this.getFileAttributes(realPath);
                if (!fileAttributes.isPresent() || !this.testFilter(realPath, base)) continue;
                return (A)fileAttributes.get();
            }
            throw new NoSuchFileException(path.toString());
        }
        throw new UnsupportedOperationException();
    }

    public void checkAccess(UnionPath p, AccessMode ... modes) throws IOException {
        try {
            this.findFirstFiltered(p).ifPresentOrElse(path -> {
                try {
                    if (modes.length == 0) {
                        if (!UnionFileSystem.fastPathExists(this, path)) {
                            throw new UncheckedIOException(new NoSuchFileException(p.toString()));
                        }
                    } else {
                        path.getFileSystem().provider().checkAccess((Path)path, modes);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }, () -> {
                throw new UncheckedIOException(new NoSuchFileException(p.toString()));
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private Path toRealPath(Path basePath, UnionPath path) {
        UnionPath embeddedpath = path.isAbsolute() ? this.root.relativize(path) : path;
        String resolvepath = embeddedpath.normalize().toString();
        EmbeddedFileSystemMetadata efsm = this.embeddedFileSystems.get(basePath);
        if (efsm != null) {
            return efsm.fs().getPath(resolvepath, new String[0]);
        }
        return basePath.resolve(resolvepath);
    }

    public SeekableByteChannel newReadByteChannel(UnionPath path) throws IOException {
        try {
            return this.findFirstFiltered(path).map(this::byteChannel).orElseThrow(FileNotFoundException::new);
        }
        catch (UncheckedIOException ioe) {
            throw ioe.getCause();
        }
    }

    private SeekableByteChannel byteChannel(Path path) {
        try {
            return Files.newByteChannel(path, StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public DirectoryStream<Path> newDirStream(UnionPath path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        final ArrayList<DirectoryStream<Path>> closeables = new ArrayList<DirectoryStream<Path>>(this.basepaths.size());
        Stream<Object> stream = Stream.empty();
        for (Path bp : this.basepaths) {
            Path dir = this.toRealPath(bp, path);
            if (!UnionFileSystem.fastPathExists(this, dir)) continue;
            boolean isSimple = this.embeddedFileSystems.containsKey(bp);
            DirectoryStream<Path> ds = Files.newDirectoryStream(dir, filter);
            closeables.add(ds);
            Stream<Path> currentPaths = StreamSupport.stream(ds.spliterator(), false).filter(p -> this.testFilter((Path)p, bp)).map(other -> this.fastPath(isSimple ? other : bp.relativize((Path)other)));
            stream = Stream.concat(stream, currentPaths);
        }
        final Stream realStream = stream.distinct();
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return realStream.iterator();
            }

            @Override
            public void close() throws IOException {
                ArrayList<IOException> exceptions = new ArrayList<IOException>();
                for (Closeable closeable : closeables) {
                    try {
                        closeable.close();
                    }
                    catch (IOException e) {
                        exceptions.add(e);
                    }
                }
                if (!exceptions.isEmpty()) {
                    IOException aggregate = new IOException("Failed to close some streams in UnionFileSystem.newDirStream");
                    exceptions.forEach(aggregate::addSuppressed);
                    throw aggregate;
                }
            }
        };
    }

    private Path fastPath(Path pathToConvert) {
        String[] parts = new String[pathToConvert.getNameCount()];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = pathToConvert.getName(i).toString();
        }
        return this.fastPath(parts);
    }

    private boolean testFilter(Path path, Path basePath) {
        String sBasePath;
        if (this.pathFilter == null) {
            return true;
        }
        Object sPath = path.toString();
        if (path.getFileSystem() == basePath.getFileSystem()) {
            sPath = basePath.relativize(path).toString().replace('\\', '/');
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            sPath = (String)sPath + SEP_STRING;
        }
        if (((String)sPath).length() > 1 && ((String)sPath).startsWith(SEP_STRING)) {
            sPath = ((String)sPath).substring(1);
        }
        if ((sBasePath = basePath.toString().replace('\\', '/')).length() > 1 && sBasePath.startsWith(SEP_STRING)) {
            sBasePath = sBasePath.substring(1);
        }
        return this.pathFilter.test((String)sPath, sBasePath);
    }

    static {
        try {
            Field hackfield = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            hackfield.setAccessible(true);
            MethodHandles.Lookup hack = (MethodHandles.Lookup)hackfield.get(null);
            Class<?> clz = Class.forName("jdk.nio.zipfs.ZipPath");
            ZIPFS_EXISTS = hack.findSpecial(clz, "exists", MethodType.methodType(Boolean.TYPE), clz);
            clz = Class.forName("jdk.nio.zipfs.ZipFileSystem");
            ZIPFS_CH = hack.findGetter(clz, "ch", SeekableByteChannel.class);
            clz = Class.forName("sun.nio.ch.FileChannelImpl");
            FCI_UNINTERUPTIBLE = hack.findSpecial(clz, "setUninterruptible", MethodType.methodType(Void.TYPE), clz);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static class UncheckedIOException
    extends java.io.UncheckedIOException {
        public UncheckedIOException(IOException cause) {
            super(cause);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private record EmbeddedFileSystemMetadata(Path path, FileSystem fs, SeekableByteChannel fsCh) {
    }

    private static class NoSuchFileException
    extends java.nio.file.NoSuchFileException {
        public NoSuchFileException(String file) {
            super(file);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

