/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.ManifestVerifier;
import cpw.mods.jarhandling.impl.SecureJarVerifier;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.jetbrains.annotations.Nullable;

public class JarSigningData {
    private static final CodeSigner[] EMPTY_CODESIGNERS = new CodeSigner[0];
    private final Hashtable<String, CodeSigner[]> pendingSigners = new Hashtable();
    private final Hashtable<String, CodeSigner[]> verifiedSigners = new Hashtable();
    private final ManifestVerifier verifier = new ManifestVerifier();
    private final Map<String, StatusData> statusData = new HashMap<String, StatusData>();

    void readJarSigningData(JarInputStream jis) throws IOException {
        Object jv = SecureJarVerifier.getJarVerifier(jis);
        if (jv != null) {
            while (SecureJarVerifier.isParsingMeta(jv) && jis.getNextJarEntry() != null) {
            }
            if (SecureJarVerifier.hasSignatures(jv)) {
                this.pendingSigners.putAll(SecureJarVerifier.getPendingSigners(jv));
                CodeSigner[] manifestSigners = SecureJarVerifier.getVerifiedSigners(jv).get("META-INF/MANIFEST.MF");
                if (manifestSigners != null) {
                    this.verifiedSigners.put("META-INF/MANIFEST.MF", manifestSigners);
                }
                StatusData.add("META-INF/MANIFEST.MF", SecureJar.Status.VERIFIED, this.verifiedSigners.get("META-INF/MANIFEST.MF"), this);
            }
        }
    }

    @Nullable
    CodeSigner[] getManifestSigners() {
        return this.getData("META-INF/MANIFEST.MF").map(r -> r.signers).orElse(null);
    }

    SecureJar.Status verifyPath(Manifest manifest, Path path, String filename) {
        if (this.statusData.containsKey(filename)) {
            return this.getFileStatus(filename);
        }
        try {
            byte[] bytes = Files.readAllBytes(path);
            this.verifyAndGetSigners(manifest, filename, bytes);
            return this.getFileStatus(filename);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    SecureJar.Status getFileStatus(String name) {
        return this.hasSecurityData() ? this.getData(name).map(r -> r.status).orElse(SecureJar.Status.NONE) : SecureJar.Status.UNVERIFIED;
    }

    @Nullable
    Attributes getTrustedManifestEntries(Manifest manifest, String name) {
        Attributes manattrs = manifest.getAttributes(name);
        CodeSigner[] mansigners = this.getManifestSigners();
        CodeSigner[] objsigners = this.getData(name).map(sd -> sd.signers).orElse(EMPTY_CODESIGNERS);
        if (mansigners == null || mansigners.length == objsigners.length) {
            return manattrs;
        }
        return null;
    }

    boolean hasSecurityData() {
        return !this.pendingSigners.isEmpty() || !this.verifiedSigners.isEmpty();
    }

    private Optional<StatusData> getData(String name) {
        return Optional.ofNullable(this.statusData.get(name));
    }

    synchronized CodeSigner[] verifyAndGetSigners(Manifest manifest, String name, byte[] bytes) {
        if (!this.hasSecurityData()) {
            return null;
        }
        if (this.statusData.containsKey(name)) {
            return this.statusData.get((Object)name).signers;
        }
        Optional<CodeSigner[]> signers = this.verifier.verify(manifest, this.pendingSigners, this.verifiedSigners, name, bytes);
        if (signers == null) {
            StatusData.add(name, SecureJar.Status.INVALID, null, this);
            return null;
        }
        CodeSigner[] ret = signers.orElse(null);
        StatusData.add(name, SecureJar.Status.VERIFIED, ret, this);
        return ret;
    }

    record StatusData(String name, SecureJar.Status status, CodeSigner[] signers) {
        static void add(String name, SecureJar.Status status, CodeSigner[] signers, JarSigningData data) {
            data.statusData.put(name, new StatusData(name, status, signers));
        }
    }
}

