/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.impl.Jar;
import cpw.mods.jarhandling.impl.JarContentsImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.Nullable;

public interface SecureJar {
    public static SecureJar from(Path ... paths) {
        return SecureJar.from(new JarContentsBuilder().paths(paths).build());
    }

    public static SecureJar from(JarContents contents) {
        return SecureJar.from(contents, JarMetadata.from(contents));
    }

    public static SecureJar from(JarContents contents, JarMetadata metadata) {
        return new Jar((JarContentsImpl)contents, metadata);
    }

    public ModuleDataProvider moduleDataProvider();

    public Path getPrimaryPath();

    @Nullable
    public CodeSigner[] getManifestSigners();

    public Status verifyPath(Path var1);

    public Status getFileStatus(String var1);

    @Nullable
    public Attributes getTrustedManifestEntries(String var1);

    public boolean hasSecurityData();

    public String name();

    public Path getPath(String var1, String ... var2);

    public Path getRootPath();

    @Deprecated(forRemoval=true, since="2.1.16")
    default public Set<String> getPackages() {
        return this.moduleDataProvider().descriptor().packages();
    }

    @Deprecated(forRemoval=true, since="2.1.16")
    public List<Provider> getProviders();

    @Deprecated(forRemoval=true, since="2.1.16")
    public static SecureJar from(BiPredicate<String, String> filter, Path ... paths) {
        return SecureJar.from((SecureJar jar) -> JarMetadata.from(jar, paths), filter, paths);
    }

    @Deprecated(forRemoval=true, since="2.1.16")
    public static SecureJar from(Function<SecureJar, JarMetadata> metadataSupplier, Path ... paths) {
        return SecureJar.from(Manifest::new, metadataSupplier, paths);
    }

    @Deprecated(forRemoval=true, since="2.1.16")
    public static SecureJar from(Function<SecureJar, JarMetadata> metadataSupplier, BiPredicate<String, String> filter, Path ... paths) {
        return SecureJar.from(Manifest::new, metadataSupplier, filter, paths);
    }

    @Deprecated(forRemoval=true, since="2.1.16")
    public static SecureJar from(Supplier<Manifest> defaultManifest, Function<SecureJar, JarMetadata> metadataSupplier, Path ... paths) {
        return SecureJar.from(defaultManifest, metadataSupplier, null, paths);
    }

    @Deprecated(forRemoval=true, since="2.1.16")
    public static SecureJar from(Supplier<Manifest> defaultManifest, Function<SecureJar, JarMetadata> metadataSupplier, BiPredicate<String, String> filter, Path ... paths) {
        return new Jar(defaultManifest, metadataSupplier, filter, paths);
    }

    public static interface ModuleDataProvider {
        public String name();

        public ModuleDescriptor descriptor();

        public URI uri();

        public Optional<URI> findFile(String var1);

        public Optional<InputStream> open(String var1);

        public Manifest getManifest();

        public CodeSigner[] verifyAndGetSigners(String var1, byte[] var2);
    }

    public static enum Status {
        NONE,
        INVALID,
        UNVERIFIED,
        VERIFIED;

    }

    public record Provider(String serviceName, List<String> providers) {
        public static Provider fromPath(Path path, BiPredicate<String, String> pkgFilter) {
            String sname = path.getFileName().toString();
            try {
                List<String> entries = Files.readAllLines(path).stream().map(String::trim).filter(l -> l.length() > 0 && !l.startsWith("#")).filter(p -> pkgFilter == null || pkgFilter.test(p.replace('.', '/'), "")).toList();
                return new Provider(sname, entries);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

