/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.ModuleJarMetadata;
import cpw.mods.jarhandling.impl.SimpleJarMetadata;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface JarMetadata {
    public static final Pattern DASH_VERSION = Pattern.compile("-([.\\d]+)");
    public static final Pattern NON_ALPHANUM = Pattern.compile("[^A-Za-z0-9]");
    public static final Pattern REPEATING_DOTS = Pattern.compile("(\\.)(\\1)+");
    public static final Pattern LEADING_DOTS = Pattern.compile("^\\.");
    public static final Pattern TRAILING_DOTS = Pattern.compile("\\.$");
    public static final Pattern MODULE_VERSION = Pattern.compile("(?<=^|-)([\\d][.\\d]*)");
    public static final Pattern NUMBERLIKE_PARTS = Pattern.compile("(?<=^|\\.)([0-9]+)");
    public static final List<String> ILLEGAL_KEYWORDS = List.of("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");
    public static final Pattern KEYWORD_PARTS = Pattern.compile("(?<=^|\\.)(" + String.join((CharSequence)"|", ILLEGAL_KEYWORDS) + ")(?=\\.|$)");

    public String name();

    public String version();

    public ModuleDescriptor descriptor();

    public static JarMetadata from(JarContents jar) {
        Set<String> pkgs = jar.getPackages();
        Optional<URI> mi = jar.findFile("module-info.class");
        if (mi.isPresent()) {
            return new ModuleJarMetadata(mi.get(), pkgs);
        }
        List<SecureJar.Provider> providers = jar.getMetaInfServices();
        SimpleJarMetadata fileCandidate = JarMetadata.fromFileName(jar.getPrimaryPath(), pkgs, providers);
        String aname = jar.getManifest().getMainAttributes().getValue("Automatic-Module-Name");
        if (aname != null) {
            return new SimpleJarMetadata(aname, fileCandidate.version(), pkgs, providers);
        }
        return fileCandidate;
    }

    public static SimpleJarMetadata fromFileName(Path path, Set<String> pkgs, List<SecureJar.Provider> providers) {
        Matcher mat;
        Path artifactNameMaybe;
        Path artifactMaybe;
        Path versionMaybe = path.getParent();
        if (versionMaybe != null && (artifactMaybe = versionMaybe.getParent()) != null && (artifactNameMaybe = artifactMaybe.getFileName()) != null && path.getFileName().toString().startsWith(artifactNameMaybe + "-" + versionMaybe.getFileName().toString())) {
            String name = artifactMaybe.getFileName().toString();
            String ver = versionMaybe.getFileName().toString();
            Matcher mat2 = MODULE_VERSION.matcher(ver);
            if (mat2.find()) {
                String potential = ver.substring(mat2.start());
                ver = JarMetadata.safeParseVersion(potential, path.getFileName().toString());
                return new SimpleJarMetadata(JarMetadata.cleanModuleName(name), ver, pkgs, providers);
            }
            return new SimpleJarMetadata(JarMetadata.cleanModuleName(name), null, pkgs, providers);
        }
        String fn = path.getFileName().toString();
        int lastDot = fn.lastIndexOf(46);
        if (lastDot > 0) {
            fn = fn.substring(0, lastDot);
        }
        if ((mat = DASH_VERSION.matcher(fn)).find()) {
            String potential = fn.substring(mat.start() + 1);
            String ver = JarMetadata.safeParseVersion(potential, path.getFileName().toString());
            String name = mat.replaceAll("");
            return new SimpleJarMetadata(JarMetadata.cleanModuleName(name), ver, pkgs, providers);
        }
        return new SimpleJarMetadata(JarMetadata.cleanModuleName(fn), null, pkgs, providers);
    }

    private static String safeParseVersion(String ver, String filename) {
        try {
            int len = ver.length();
            if (len == 0) {
                throw new IllegalArgumentException("Error parsing version info from " + filename + ": Empty Version String");
            }
            char last = ver.charAt(len - 1);
            if (last == '.' || last == '+' || last == '-') {
                if (len == 1) {
                    throw new IllegalArgumentException("Error parsing version info from " + filename + ": Invalid version \"" + ver + "\"");
                }
                ver = ver.substring(0, len - 1);
            }
            return ModuleDescriptor.Version.parse(ver).toString();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error parsing version info from " + filename + " (" + ver + "): " + e.getMessage(), e);
        }
    }

    private static String cleanModuleName(String mn) {
        int len;
        mn = NON_ALPHANUM.matcher(mn).replaceAll(".");
        if (!(mn = REPEATING_DOTS.matcher(mn).replaceAll(".")).isEmpty() && mn.charAt(0) == '.') {
            mn = LEADING_DOTS.matcher(mn).replaceAll("");
        }
        if ((len = mn.length()) > 0 && mn.charAt(len - 1) == '.') {
            mn = TRAILING_DOTS.matcher(mn).replaceAll("");
        }
        mn = NUMBERLIKE_PARTS.matcher(mn).replaceAll("_$1");
        mn = KEYWORD_PARTS.matcher(mn).replaceAll("_$1");
        return mn;
    }

    @Deprecated(forRemoval=true, since="2.1.16")
    public static JarMetadata from(SecureJar jar, Path ... path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("Need at least one path");
        }
        Set<String> pkgs = jar.getPackages();
        Optional<URI> mi = jar.moduleDataProvider().findFile("module-info.class");
        if (mi.isPresent()) {
            return new ModuleJarMetadata(mi.get(), pkgs);
        }
        List<SecureJar.Provider> providers = jar.getProviders();
        SimpleJarMetadata fileCandidate = JarMetadata.fromFileName(path[0], pkgs, providers);
        String aname = jar.moduleDataProvider().getManifest().getMainAttributes().getValue("Automatic-Module-Name");
        if (aname != null) {
            return new SimpleJarMetadata(aname, fileCandidate.version(), pkgs, providers);
        }
        return fileCandidate;
    }
}

