/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.niofs.union;

import cpw.mods.niofs.union.UnionFileSystem;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class UnionPath
implements Path {
    private final UnionFileSystem fileSystem;
    private final String[] pathParts;
    static final String ROOT = "";

    UnionPath(UnionFileSystem fileSystem, String ... pathParts) {
        this.fileSystem = fileSystem;
        if (pathParts.length == 0) {
            this.pathParts = new String[0];
        } else {
            String longstring = String.join((CharSequence)fileSystem.getSeparator(), pathParts);
            this.pathParts = this.getPathParts(longstring);
        }
    }

    private String[] getPathParts(String longstring) {
        return longstring.replace("\\", this.getFileSystem().getSeparator()).split(this.getFileSystem().getSeparator());
    }

    @Override
    public UnionFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return ROOT.equals(this.pathParts[0]);
    }

    @Override
    public Path getRoot() {
        return new UnionPath(this.fileSystem, ROOT);
    }

    @Override
    public Path getFileName() {
        return this.pathParts.length > 0 ? new UnionPath(this.fileSystem, this.pathParts[this.pathParts.length - 1]) : null;
    }

    @Override
    public Path getParent() {
        if (this.pathParts.length > 0) {
            return new UnionPath(this.fileSystem, Arrays.copyOf(this.pathParts, this.pathParts.length - 1));
        }
        return null;
    }

    @Override
    public int getNameCount() {
        return this.pathParts.length;
    }

    @Override
    public Path getName(int index) {
        if (index < 0 || index > this.pathParts.length - 1) {
            throw new IllegalArgumentException();
        }
        return new UnionPath(this.fileSystem, this.pathParts[index]);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > this.pathParts.length - 1 || endIndex < 0 || endIndex > this.pathParts.length || beginIndex > endIndex) {
            throw new IllegalArgumentException("Out of range " + beginIndex + " to " + endIndex + " for length " + this.pathParts.length);
        }
        return new UnionPath(this.fileSystem, Arrays.copyOfRange(this.pathParts, beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        if (other.getFileSystem() != this.getFileSystem()) {
            return false;
        }
        Path path = other;
        if (path instanceof UnionPath) {
            UnionPath bp = (UnionPath)path;
            return UnionPath.checkArraysMatch(this.pathParts, bp.pathParts, false);
        }
        return false;
    }

    @Override
    public boolean endsWith(Path other) {
        if (other.getFileSystem() != this.getFileSystem()) {
            return false;
        }
        Path path = other;
        if (path instanceof UnionPath) {
            UnionPath bp = (UnionPath)path;
            return UnionPath.checkArraysMatch(this.pathParts, bp.pathParts, true);
        }
        return false;
    }

    private static boolean checkArraysMatch(String[] array1, String[] array2, boolean reverse) {
        int length = Math.min(array1.length, array2.length);
        IntBinaryOperator offset = reverse ? (l, i) -> l - i - 1 : (l, i) -> i;
        for (int i2 = 0; i2 < length; ++i2) {
            if (Objects.equals(array1[offset.applyAsInt(array1.length, i2)], array2[offset.applyAsInt(array2.length, i2)])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Path normalize() {
        ArrayDeque<String> normpath = new ArrayDeque<String>();
        String[] stringArray = this.pathParts;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String pathPart;
            switch (pathPart = stringArray[i]) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    normpath.removeLast();
                    continue block8;
                }
                default: {
                    normpath.addLast(pathPart);
                }
            }
        }
        return new UnionPath(this.fileSystem, String.join((CharSequence)this.fileSystem.getSeparator(), normpath));
    }

    @Override
    public Path resolve(Path other) {
        Path path = other;
        if (path instanceof UnionPath) {
            UnionPath path2 = (UnionPath)path;
            if (path2.isAbsolute()) {
                return path2;
            }
            return new UnionPath(this.fileSystem, this + this.fileSystem.getSeparator() + other);
        }
        return other;
    }

    @Override
    public Path relativize(Path other) {
        if (other.getFileSystem() != this.getFileSystem()) {
            throw new IllegalArgumentException("Wrong filesystem");
        }
        Path path = other;
        if (path instanceof UnionPath) {
            int i;
            UnionPath p = (UnionPath)path;
            int poff = p.isAbsolute() ? 1 : 0;
            int meoff = this.isAbsolute() ? 1 : 0;
            int length = Math.min(this.pathParts.length - meoff, p.pathParts.length - poff);
            for (i = 0; i < length && Objects.equals(this.pathParts[i + meoff], p.pathParts[i + poff]); ++i) {
            }
            int remaining = this.pathParts.length - i - meoff;
            if (remaining == 0 && i == p.pathParts.length) {
                return new UnionPath(this.getFileSystem(), new String[0]);
            }
            if (remaining == 0) {
                return p.subpath(i, p.getNameCount());
            }
            String updots = IntStream.range(0, remaining).mapToObj(idx -> "..").collect(Collectors.joining(this.getFileSystem().getSeparator()));
            if (i == p.pathParts.length) {
                return new UnionPath(this.getFileSystem(), updots);
            }
            return new UnionPath(this.getFileSystem(), updots + this.getFileSystem().getSeparator() + p.subpath(i, p.getNameCount()));
        }
        throw new IllegalArgumentException("Wrong filesystem");
    }

    @Override
    public URI toUri() {
        try {
            return new URI(this.fileSystem.provider().getScheme(), null, this.fileSystem.getKey() + "!" + this.toAbsolutePath(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.fileSystem.getRoot().resolve(this);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return null;
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Path other) {
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof UnionPath) {
            UnionPath p = (UnionPath)object;
            return p.getFileSystem() == this.getFileSystem() && Arrays.equals(this.pathParts, p.pathParts);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.fileSystem) + 31 * Arrays.hashCode(this.pathParts);
    }

    @Override
    public String toString() {
        return String.join((CharSequence)this.fileSystem.getSeparator(), this.pathParts);
    }
}

