/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.niofs.union;

import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.niofs.union.UnionPath;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;

public class UnionFileSystemProvider
extends FileSystemProvider {
    private final Map<String, UnionFileSystem> fileSystems = new HashMap<String, UnionFileSystem>();
    private int index = 0;

    @Override
    public String getScheme() {
        return "union";
    }

    protected Path uriToPath(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI scheme is not '" + this.getScheme() + "'");
        }
        try {
            String spec = uri.getRawSchemeSpecificPart();
            int sep = spec.indexOf("!/");
            if (sep != -1) {
                spec = spec.substring(0, sep);
            }
            return Paths.get(new URI(spec)).toAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        List additional = env.getOrDefault("additional", List.of());
        BiPredicate<String, String> filter = env.getOrDefault("filter", null);
        if (filter == null && additional.isEmpty()) {
            throw new IllegalArgumentException("Missing additional and/or filter");
        }
        if (filter == null) {
            filter = (p, b) -> true;
        }
        Path path = this.uriToPath(uri);
        String key = this.makeKey(path);
        try {
            return this.newFileSystemInternal(key, filter, (Path[])Stream.concat(Stream.of(path), additional.stream()).toArray(Path[]::new));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        List additional = env.getOrDefault("additional", List.of());
        BiPredicate<String, String> filter = env.getOrDefault("filter", null);
        if (filter == null && additional.isEmpty()) {
            throw new UnsupportedOperationException("Missing additional and/or filter");
        }
        if (filter == null) {
            filter = (p, b) -> true;
        }
        String key = this.makeKey(path);
        try {
            return this.newFileSystemInternal(key, filter, (Path[])Stream.concat(Stream.of(path), additional.stream()).toArray(Path[]::new));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public UnionFileSystem newFileSystem(BiPredicate<String, String> pathfilter, Path ... paths) {
        if (paths.length == 0) {
            throw new IllegalArgumentException("Need at least one path");
        }
        String key = this.makeKey(paths[0]);
        return this.newFileSystemInternal(key, pathfilter, paths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnionFileSystem newFileSystemInternal(String key, BiPredicate<String, String> pathfilter, Path ... paths) {
        Path[] normpaths = (Path[])Arrays.stream(paths).map(Path::toAbsolutePath).map(Path::normalize).toArray(Path[]::new);
        Map<String, UnionFileSystem> map = this.fileSystems;
        synchronized (map) {
            UnionFileSystem ufs = new UnionFileSystem(this, pathfilter, key, normpaths);
            this.fileSystems.put(key, ufs);
            return ufs;
        }
    }

    private synchronized String makeKey(Path path) {
        return path.toAbsolutePath().normalize().toUri().getPath() + "#" + this.index++;
    }

    @Override
    public Path getPath(URI uri) {
        String[] parts = uri.getPath().split("!");
        if (parts.length > 1) {
            return this.getFileSystem(uri).getPath(parts[1], new String[0]);
        }
        return ((UnionFileSystem)this.getFileSystem(uri)).getRoot();
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        String[] parts = uri.getPath().split("!");
        if (!this.fileSystems.containsKey(parts[0])) {
            throw new FileSystemNotFoundException();
        }
        return this.fileSystems.get(parts[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Path path2 = path;
        if (path2 instanceof UnionPath) {
            UnionPath up = (UnionPath)path2;
            if (options.size() > 1) {
                throw new UnsupportedOperationException();
            }
            if (!options.isEmpty() && !options.contains(StandardOpenOption.READ)) {
                throw new UnsupportedOperationException();
            }
            return up.getFileSystem().newReadByteChannel(up);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Path path = dir;
        if (path instanceof UnionPath) {
            UnionPath up = (UnionPath)path;
            return up.getFileSystem().newDirStream(up, filter);
        }
        return null;
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return false;
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return null;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        Path path2 = path;
        if (path2 instanceof UnionPath) {
            UnionPath p = (UnionPath)path2;
            p.getFileSystem().checkAccess(p, modes);
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        Path path2 = path;
        if (path2 instanceof UnionPath) {
            UnionPath p = (UnionPath)path2;
            return p.getFileSystem().readAttributes(p, type, new LinkOption[0]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileSystem(UnionFileSystem fs) {
        Map<String, UnionFileSystem> map = this.fileSystems;
        synchronized (map) {
            this.fileSystems.remove(fs.getKey());
        }
    }
}

