/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.ModuleJarMetadata;
import cpw.mods.jarhandling.impl.SimpleJarMetadata;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface JarMetadata {
    public static final Pattern DASH_VERSION = Pattern.compile("-(\\d+(\\.|$))");
    public static final Pattern NON_ALPHANUM = Pattern.compile("[^A-Za-z0-9]");
    public static final Pattern REPEATING_DOTS = Pattern.compile("(\\.)(\\1)+");
    public static final Pattern LEADING_DOTS = Pattern.compile("^\\.");
    public static final Pattern TRAILING_DOTS = Pattern.compile("\\.$");

    public String name();

    public String version();

    public ModuleDescriptor descriptor();

    public static JarMetadata from(SecureJar jar, Path ... path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("Need at least one path");
        }
        Set<String> pkgs = jar.getPackages();
        Optional<URI> mi = jar.findFile("module-info.class");
        if (mi.isPresent()) {
            return new ModuleJarMetadata(mi.get(), pkgs);
        }
        List<SecureJar.Provider> providers = jar.getProviders();
        SimpleJarMetadata fileCandidate = JarMetadata.fromFileName(path[0], pkgs, providers);
        String aname = jar.getManifest().getMainAttributes().getValue("Automatic-Module-Name");
        if (aname != null) {
            return new SimpleJarMetadata(aname, fileCandidate.version(), pkgs, providers);
        }
        return fileCandidate;
    }

    public static SimpleJarMetadata fromFileName(Path path, Set<String> pkgs, List<SecureJar.Provider> providers) {
        String fn = path.getFileName().toString();
        Matcher mat = DASH_VERSION.matcher(fn = fn.substring(0, fn.length() - 4));
        if (mat.find()) {
            String ver = ModuleDescriptor.Version.parse(fn.substring(mat.start() + 1)).toString();
            String name = fn.substring(0, mat.start());
            return new SimpleJarMetadata(JarMetadata.cleanModuleName(name), ver, pkgs, providers);
        }
        return new SimpleJarMetadata(JarMetadata.cleanModuleName(fn), null, pkgs, providers);
    }

    private static String cleanModuleName(String mn) {
        int len;
        mn = NON_ALPHANUM.matcher(mn).replaceAll(".");
        if (!(mn = REPEATING_DOTS.matcher(mn).replaceAll(".")).isEmpty() && mn.charAt(0) == '.') {
            mn = LEADING_DOTS.matcher(mn).replaceAll("");
        }
        if ((len = mn.length()) > 0 && mn.charAt(len - 1) == '.') {
            mn = TRAILING_DOTS.matcher(mn).replaceAll("");
        }
        return mn;
    }
}

