/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.niofs.union;

import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.niofs.union.UnionPath;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class UnionFileSystemProvider
extends FileSystemProvider {
    private final Map<Path, UnionFileSystem> fileSystems = new HashMap<Path, UnionFileSystem>();
    private final UnionFileSystem DUMMY = new UnionFileSystem(this, new Path[0]);

    @Override
    public String getScheme() {
        return "union";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        Path path = Path.of(uri.getPath().split("!")[0], new String[0]).toAbsolutePath().normalize();
        if (this.fileSystems.get(path) == this.DUMMY) {
            throw new UnsupportedOperationException();
        }
        this.fileSystems.put(path, this.DUMMY);
        List additional = env.containsKey("additional") ? (List)env.get("additional") : List.of();
        try {
            return this.newFileSystem((Path[])Stream.concat(Stream.of(path), additional.stream()).toArray(Path[]::new));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    @Override
    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        if (this.fileSystems.get(path) == this.DUMMY) {
            throw new UnsupportedOperationException();
        }
        this.fileSystems.put(path, this.DUMMY);
        List additional = env.containsKey("additional") ? (List)env.get("additional") : List.of();
        try {
            return this.newFileSystem((Path[])Stream.concat(Stream.of(path), additional.stream()).toArray(Path[]::new));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public UnionFileSystem newFileSystem(Path ... paths) {
        if (paths.length == 0) {
            throw new IllegalArgumentException("Need at least one path");
        }
        Path[] normpaths = (Path[])Arrays.stream(paths).map(Path::toAbsolutePath).map(Path::normalize).toArray(Path[]::new);
        this.fileSystems.put(normpaths[0], this.DUMMY);
        UnionFileSystem ufs = new UnionFileSystem(this, normpaths);
        this.fileSystems.put(normpaths[0], ufs);
        return ufs;
    }

    @Override
    public Path getPath(URI uri) {
        String[] parts = uri.getPath().split("!");
        if (parts.length > 1) {
            return this.getFileSystem(uri).getPath(parts[1], new String[0]);
        }
        return ((UnionFileSystem)this.getFileSystem(uri)).getRoot();
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        String[] parts = uri.getPath().split("!");
        Path basePath = Paths.get(parts[0], new String[0]).toAbsolutePath().normalize();
        if (!this.fileSystems.containsKey(basePath)) {
            throw new FileSystemNotFoundException();
        }
        return this.fileSystems.get(basePath);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Path path2 = path;
        if (path2 instanceof UnionPath) {
            UnionPath up = (UnionPath)path2;
            if (options.size() > 1) {
                throw new UnsupportedOperationException();
            }
            if (!options.isEmpty() && !options.contains(StandardOpenOption.READ)) {
                throw new UnsupportedOperationException();
            }
            return up.getFileSystem().newReadByteChannel(up);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Path path = dir;
        if (path instanceof UnionPath) {
            UnionPath up = (UnionPath)path;
            return up.getFileSystem().newDirStream(up, filter);
        }
        return null;
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return false;
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return null;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        Path path2 = path;
        if (path2 instanceof UnionPath) {
            UnionPath p = (UnionPath)path2;
            p.getFileSystem().checkAccess(p, modes);
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        Path path2 = path;
        if (path2 instanceof UnionPath) {
            UnionPath p = (UnionPath)path2;
            return p.getFileSystem().readAttributes(p, type, new LinkOption[0]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }
}

