/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.niofs.union;

import cpw.mods.niofs.union.UnionFileSystemProvider;
import cpw.mods.niofs.union.UnionPath;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class UnionFileSystem
extends FileSystem {
    private final UnionPath root = new UnionPath(this, "");
    private final UnionFileSystemProvider provider;
    private final List<Path> basepaths;
    private final Map<Path, EmbeddedFileSystemMetadata> embeddedFileSystems;

    public UnionFileSystem(UnionFileSystemProvider provider, Path ... basepaths) {
        this.provider = provider;
        this.basepaths = IntStream.range(0, basepaths.length).mapToObj(i -> basepaths[basepaths.length - i - 1]).toList();
        this.embeddedFileSystems = this.basepaths.stream().filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(UnionFileSystem::openFileSystem).flatMap(Optional::stream).collect(Collectors.toMap(EmbeddedFileSystemMetadata::path, Function.identity()));
    }

    private static Optional<EmbeddedFileSystemMetadata> openFileSystem(Path path) {
        try {
            return Optional.of(new EmbeddedFileSystemMetadata(path, FileSystems.newFileSystem(path)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public UnionFileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return Collections.singletonList(this.root);
    }

    public Path getRoot() {
        return this.root;
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return Collections::emptyIterator;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return Set.of("basic");
    }

    @Override
    public Path getPath(String first, String ... more) {
        return new UnionPath(this, first + this.getSeparator() + String.join((CharSequence)this.getSeparator(), more));
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() {
        throw new UnsupportedOperationException();
    }

    List<Path> getBasePaths() {
        return this.basepaths;
    }

    private Optional<BasicFileAttributes> getFileAttributes(Path path) {
        try {
            return Optional.of(path.getFileSystem().provider().readAttributes(path, BasicFileAttributes.class, new LinkOption[0]));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private Optional<Path> findFirstPathAt(UnionPath path) {
        return this.basepaths.stream().map(p -> this.unionPath((Path)p, path)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst();
    }

    private <T> Stream<T> streamPathList(Function<Path, Optional<T>> function) {
        return this.basepaths.stream().map(function).flatMap(Optional::stream);
    }

    public <A extends BasicFileAttributes> A readAttributes(UnionPath path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class) {
            return (A)((BasicFileAttributes)this.findFirstPathAt(path).flatMap(this::getFileAttributes).orElseThrow(() -> new FileNotFoundException("Missing path " + path)));
        }
        throw new UnsupportedOperationException();
    }

    public void checkAccess(UnionPath p, AccessMode ... modes) throws IOException {
        try {
            this.findFirstPathAt(p).ifPresentOrElse(path -> {
                try {
                    path.getFileSystem().provider().checkAccess((Path)path, modes);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }, () -> {
                throw new UncheckedIOException("No file found", new FileNotFoundException());
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private Path unionPath(Path basePath, UnionPath path) {
        String resolvepath;
        String embeddedpath = path.toString();
        String string = resolvepath = embeddedpath.length() > 1 && path.isAbsolute() ? path.toString().substring(1) : embeddedpath;
        if (this.embeddedFileSystems.containsKey(basePath)) {
            return this.embeddedFileSystems.get(basePath).fs().getPath(resolvepath, new String[0]);
        }
        return basePath.resolve(resolvepath);
    }

    public SeekableByteChannel newReadByteChannel(UnionPath path) throws IOException {
        try {
            return this.findFirstPathAt(path).map(this::byteChannel).orElseThrow(FileNotFoundException::new);
        }
        catch (UncheckedIOException ioe) {
            throw ioe.getCause();
        }
    }

    private SeekableByteChannel byteChannel(Path path) {
        try {
            return Files.newByteChannel(path, StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public DirectoryStream<Path> newDirStream(UnionPath path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        final LinkedHashSet allpaths = new LinkedHashSet();
        for (Path bp : this.basepaths) {
            Path dir = this.unionPath(bp, path);
            if (!Files.exists(dir, new LinkOption[0])) continue;
            DirectoryStream<Path> ds = Files.newDirectoryStream(dir, filter);
            StreamSupport.stream(ds.spliterator(), false).map(other -> (this.embeddedFileSystems.containsKey(bp) ? other : bp.relativize((Path)other)).toString()).map(x$0 -> this.getPath((String)x$0, new String[0])).forEachOrdered(allpaths::add);
        }
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return allpaths.iterator();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    private record EmbeddedFileSystemMetadata(Path path, FileSystem fs) {
    }
}

