/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.SecureJarVerifier;
import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.niofs.union.UnionFileSystemProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.security.CodeSigner;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarException;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sun.security.util.ManifestEntryVerifier;

public class Jar
implements SecureJar {
    private static final CodeSigner[] EMPTY_CODESIGNERS = new CodeSigner[0];
    private static final UnionFileSystemProvider UFSP = (UnionFileSystemProvider)FileSystemProvider.installedProviders().stream().filter(fsp -> fsp.getScheme().equals("union")).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find UnionFileSystemProvider"));
    private final Manifest manifest;
    private final ManifestEntryVerifier mev;
    private final Hashtable<String, CodeSigner[]> pendingSigners;
    private final Hashtable<String, CodeSigner[]> existingSigners;
    private final boolean secure;
    private final Map<String, StatusData> statusData;
    private final JarMetadata metadata;
    private final UnionFileSystem filesystem;
    private final boolean isMultiRelease;
    private final Map<Path, Integer> nameOverrides;

    public URI getURI() {
        return this.filesystem.getRootDirectories().iterator().next().toUri();
    }

    public ModuleDescriptor computeDescriptor() {
        return this.metadata.descriptor();
    }

    @Override
    public Optional<URI> findFile(String name) {
        Path rel = this.filesystem.getPath(name, new String[0]);
        if (this.nameOverrides.containsKey(rel)) {
            rel = this.filesystem.getPath("META-INF", "versions", this.nameOverrides.get(rel).toString()).resolve(rel);
        }
        return Optional.of(this.filesystem.getRoot().resolve(rel)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toUri);
    }

    public Jar(Supplier<Manifest> defaultManifest, Function<SecureJar, JarMetadata> metadataFunction, Path ... paths) {
        block31: {
            block30: {
                this.pendingSigners = new Hashtable();
                this.existingSigners = new Hashtable();
                this.statusData = new HashMap<String, StatusData>();
                Path path = paths[0];
                this.filesystem = UFSP.newFileSystem(paths);
                try {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        Path manfile = path.resolve("META-INF/MANIFEST.MF");
                        if (Files.exists(manfile, new LinkOption[0])) {
                            try (InputStream is = Files.newInputStream(manfile, new OpenOption[0]);){
                                this.manifest = new Manifest(is);
                            }
                        } else {
                            this.manifest = defaultManifest.get();
                        }
                        this.mev = null;
                        this.secure = false;
                        break block30;
                    }
                    try (JarInputStream jis = new JarInputStream(Files.newInputStream(path, new OpenOption[0]));){
                        if (SecureJarVerifier.jarVerifier.get(jis) != null) {
                            while (((Boolean)SecureJarVerifier.parsingMeta.get(SecureJarVerifier.jarVerifier.get(jis))).booleanValue()) {
                                jis.getNextJarEntry();
                            }
                            this.secure = SecureJarVerifier.anyToVerify.getBoolean(SecureJarVerifier.jarVerifier.get(jis));
                            this.manifest = new Manifest(jis.getManifest());
                            this.mev = new ManifestEntryVerifier(this.manifest);
                        } else {
                            this.secure = false;
                            this.manifest = defaultManifest.get();
                            this.mev = null;
                        }
                        if (this.secure) {
                            this.pendingSigners.putAll((Hashtable)SecureJarVerifier.sigFileSigners.get(SecureJarVerifier.jarVerifier.get(jis)));
                            this.existingSigners.put("META-INF/MANIFEST.MF", (CodeSigner[])((Hashtable)SecureJarVerifier.existingSigners.get(SecureJarVerifier.jarVerifier.get(jis))).get("META-INF/MANIFEST.MF"));
                            StatusData.add("META-INF/MANIFEST.MF", SecureJar.Status.VERIFIED, this.existingSigners.get("META-INF/MANIFEST.MF"), this);
                        }
                    }
                }
                catch (IllegalAccessException e2) {
                    throw new RuntimeException(e2);
                }
                catch (IOException e3) {
                    throw new UncheckedIOException(e3);
                }
            }
            this.isMultiRelease = Boolean.parseBoolean(this.getManifest().getMainAttributes().getValue("Multi-Release"));
            if (this.isMultiRelease) {
                Path vers = this.filesystem.getRoot().resolve("META-INF/versions");
                try (Stream<Path> walk = Files.walk(vers, new FileVisitOption[0]);){
                    Map allnames = walk.filter(p1 -> !p1.isAbsolute()).filter(path1 -> !Files.isDirectory(path1, new LinkOption[0])).map(p1 -> p1.subpath(2, p1.getNameCount())).collect(Collectors.groupingBy(p -> p.subpath(1, p.getNameCount()), Collectors.mapping(p -> Integer.parseInt(p.getName(0).toString()), Collectors.toUnmodifiableList())));
                    this.nameOverrides = allnames.entrySet().stream().map(e -> Map.entry((Path)e.getKey(), ((List)e.getValue()).stream().reduce(Integer::max).orElse(8))).filter(e -> (Integer)e.getValue() < Runtime.version().feature()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    break block31;
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            }
            this.nameOverrides = Map.of();
        }
        this.metadata = metadataFunction.apply(this);
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public CodeSigner[] getManifestSigners() {
        return this.getData("META-INF/MANIFEST.MF").map(r -> r.signers).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CodeSigner[] verifyAndGetSigners(String name, byte[] bytes) {
        if (!this.secure) {
            return null;
        }
        if (this.statusData.containsKey(name)) {
            return this.statusData.get((Object)name).signers;
        }
        this.setMEVName(name);
        this.mev.update(bytes, 0, bytes.length);
        try {
            CodeSigner[] codeSigners = this.mev.verify(this.existingSigners, this.pendingSigners);
            StatusData.add(name, SecureJar.Status.VERIFIED, codeSigners, this);
            CodeSigner[] codeSignerArray = codeSigners;
            return codeSignerArray;
        }
        catch (SecurityException | JarException e) {
            StatusData.add(name, SecureJar.Status.INVALID, null, this);
            CodeSigner[] codeSignerArray = null;
            return codeSignerArray;
        }
        finally {
            this.setMEVName(null);
        }
    }

    private void setMEVName(String name) {
        try {
            this.mev.setEntry(name, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Optional<StatusData> getData(String name) {
        return Optional.ofNullable(this.statusData.get(name));
    }

    @Override
    public SecureJar.Status getFileStatus(String name) {
        return this.secure ? this.getData(name).map(r -> r.status).orElse(SecureJar.Status.NONE) : SecureJar.Status.UNVERIFIED;
    }

    @Override
    public Attributes getTrustedManifestEntries(String name) {
        Attributes manattrs = this.manifest.getAttributes(name);
        CodeSigner[] mansigners = this.getManifestSigners();
        CodeSigner[] objsigners = this.getData(name).map(sd -> sd.signers).orElse(EMPTY_CODESIGNERS);
        if (mansigners == null || mansigners.length == objsigners.length) {
            return manattrs;
        }
        return null;
    }

    @Override
    public boolean hasSecurityData() {
        return this.secure;
    }

    @Override
    public String name() {
        return this.metadata.name();
    }

    @Override
    public Set<String> getPackages() {
        Set<String> set;
        block8: {
            Stream<Path> walk = Files.walk(this.filesystem.getRoot(), new FileVisitOption[0]);
            try {
                set = walk.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path -> !path.getName(0).toString().equals("META-INF")).filter(path -> path.getFileName().toString().endsWith(".class")).map(path -> path.subpath(0, path.getNameCount() - 1)).map(path -> path.toString().replace('/', '.')).filter(pkg -> pkg.length() != 0).collect(Collectors.toSet());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            walk.close();
        }
        return set;
    }

    @Override
    public List<SecureJar.Provider> getProviders() {
        Path services = this.filesystem.getRoot().resolve("META-INF/services/");
        if (Files.exists(services, new LinkOption[0])) {
            List<SecureJar.Provider> list;
            block9: {
                Stream<Path> walk = Files.walk(services, new FileVisitOption[0]);
                try {
                    list = walk.filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(SecureJar.Provider::fromPath).toList();
                    if (walk == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (walk != null) {
                            try {
                                walk.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                walk.close();
            }
            return list;
        }
        return List.of();
    }

    private record StatusData(String name, SecureJar.Status status, CodeSigner[] signers) {
        static void add(String name, SecureJar.Status status, CodeSigner[] signers, Jar jar) {
            jar.statusData.put(name, new StatusData(name, status, signers));
        }
    }
}

