/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.impl.Jar;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public interface SecureJar {
    public Optional<URI> findFile(String var1);

    public Manifest getManifest();

    public CodeSigner[] getManifestSigners();

    public CodeSigner[] verifyAndGetSigners(String var1, byte[] var2);

    public Status getFileStatus(String var1);

    public Attributes getTrustedManifestEntries(String var1);

    public boolean hasSecurityData();

    public static SecureJar from(Path path) {
        return new Jar(Manifest::new, jar -> JarMetadata.from(jar, path), path);
    }

    public static SecureJar from(Path path, Supplier<Manifest> defaultManifestSupplier) {
        return new Jar(defaultManifestSupplier, r -> null, path);
    }

    public Set<String> getPackages();

    public List<Provider> getProviders();

    public String name();

    public static enum Status {
        NONE,
        INVALID,
        UNVERIFIED,
        VERIFIED;

    }

    public record Provider(String serviceName, List<String> providers) {
        public static Provider fromPath(Path path) {
            String sname = path.getFileName().toString();
            try {
                List<String> entries = Files.readAllLines(path).stream().map(String::trim).filter(l -> l.length() > 0 && !l.startsWith("#")).toList();
                return new Provider(sname, entries);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

