/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.cl;

import cpw.mods.cl.JarModuleFinder;
import cpw.mods.cl.ModularURLHandler;
import cpw.mods.cl.ProtectionDomainHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class ModuleClassLoader
extends ClassLoader {
    private final Configuration configuration;
    private final Map<String, JarModuleFinder.JarModuleReference> resolvedRoots;
    private final Map<String, ResolvedModule> packageLookup;

    public ModuleClassLoader(String name, Configuration configuration) {
        super(name, null);
        this.configuration = configuration;
        record JarRef(ResolvedModule m, JarModuleFinder.JarModuleReference ref) {
        }
        this.resolvedRoots = configuration.modules().stream().filter(m -> m.reference() instanceof JarModuleFinder.JarModuleReference).map(m -> new JarRef((ResolvedModule)m, (JarModuleFinder.JarModuleReference)m.reference())).collect(Collectors.toMap(r -> r.m().name(), JarRef::ref));
        this.packageLookup = new HashMap<String, ResolvedModule>();
        for (ResolvedModule mod : this.configuration.modules()) {
            mod.reference().descriptor().packages().forEach(pk -> this.packageLookup.put((String)pk, mod));
        }
    }

    private URL readerToURL(ModuleReader reader, ModuleReference ref, String name) {
        try {
            return ModuleClassLoader.toURL(reader.find(name));
        }
        catch (IOException e) {
            return null;
        }
    }

    private static URL toURL(Optional<URI> uri) {
        if (uri.isPresent()) {
            try {
                return uri.get().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    private Class<?> readerToClass(ModuleReader reader, ModuleReference ref, String name) {
        byte[] bytes;
        String cname = name.replace('.', '/') + ".class";
        try (InputStream is = reader.open(cname).orElseThrow(FileNotFoundException::new);){
            bytes = is.readAllBytes();
        }
        catch (IOException ioe) {
            return null;
        }
        JarModuleFinder.JarModuleReference modroot = this.resolvedRoots.get(ref.descriptor().name());
        Package pkg = ProtectionDomainHelper.tryDefinePackage(this, name, modroot.jar().getManifest(), t -> modroot.jar().getTrustedManifestEntries((String)t), this::definePackage);
        CodeSource cs = ProtectionDomainHelper.createCodeSource(ModuleClassLoader.toURL(ref.location()), modroot.jar().verifyAndGetSigners(name, bytes));
        return this.defineClass(name, bytes, 0, bytes.length, ProtectionDomainHelper.createProtectionDomain(cs, this));
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String pname = name.substring(0, name.lastIndexOf(46));
        String mname = Optional.ofNullable(this.packageLookup.get(pname)).map(ResolvedModule::name).orElse(null);
        if (mname != null) {
            return this.findClass(mname, name);
        }
        return super.findClass(name);
    }

    private Package definePackage(String[] args) {
        return this.definePackage(args[0], args[1], args[2], args[3], args[4], args[5], args[6], null);
    }

    @Override
    public URL getResource(String name) {
        try {
            List<URL> reslist = this.findResourceList(name);
            if (!reslist.isEmpty()) {
                return reslist.get(0);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected URL findResource(String moduleName, String name) throws IOException {
        try {
            return this.loadFromModule(moduleName, (reader, ref) -> this.readerToURL((ModuleReader)reader, (ModuleReference)ref, name));
        }
        catch (UncheckedIOException ioe) {
            throw ioe.getCause();
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return Collections.enumeration(this.findResourceList(name));
    }

    private List<URL> findResourceList(String name) throws IOException {
        int idx = name.lastIndexOf(47);
        String pkgname = idx == -1 || idx == name.length() ? "" : name.substring(0, idx).replace('/', '.');
        ResolvedModule module = this.packageLookup.get(pkgname);
        if (module != null) {
            URL res = this.findResource(module.name(), name);
            return res != null ? List.of(res) : List.of();
        }
        return this.resolvedRoots.values().stream().map(JarModuleFinder.JarModuleReference::jar).map(jar -> jar.findFile(name)).map(ModuleClassLoader::toURL).filter(Objects::nonNull).toList();
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return Collections.enumeration(this.findResourceList(name));
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        try {
            return this.loadFromModule(moduleName, (reader, ref) -> this.readerToClass((ModuleReader)reader, (ModuleReference)ref, name));
        }
        catch (IOException e) {
            return null;
        }
    }

    private <T> T loadFromModule(String moduleName, BiFunction<ModuleReader, ModuleReference, T> lookup) throws IOException {
        ResolvedModule module = this.configuration.findModule(moduleName).orElseThrow(FileNotFoundException::new);
        ModuleReference ref = module.reference();
        try (ModuleReader reader = ref.open();){
            T t = lookup.apply(reader, ref);
            return t;
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
        URL.setURLStreamHandlerFactory(ModularURLHandler.INSTANCE);
        ModularURLHandler.initFrom(ModuleClassLoader.class.getModule().getLayer());
    }
}

