/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher.api;

import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TargetType;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public interface ITransformer<T> {
    public static final String[] DEFAULT_LABEL = new String[]{"default"};

    @NotNull
    public T transform(T var1, ITransformerVotingContext var2);

    @NotNull
    public TransformerVoteResult castVote(ITransformerVotingContext var1);

    @NotNull
    public Set<Target<T>> targets();

    @NotNull
    public TargetType<T> getTargetType();

    default public String[] labels() {
        return DEFAULT_LABEL;
    }

    public static final class Target<T> {
        private final String className;
        private final String elementName;
        private final String elementDescriptor;
        private final TargetType<T> targetType;

        Target(String className, String elementName, String elementDescriptor, TargetType<T> targetType) {
            Objects.requireNonNull(className, "Class Name cannot be null");
            Objects.requireNonNull(elementName, "Element Name cannot be null");
            Objects.requireNonNull(elementDescriptor, "Element Descriptor cannot be null");
            Objects.requireNonNull(targetType, "Target Type cannot be null");
            this.className = className;
            this.elementName = elementName;
            this.elementDescriptor = elementDescriptor;
            this.targetType = targetType;
        }

        @NotNull
        public static Target<ClassNode> targetClass(String className) {
            return new Target<ClassNode>(className, "", "", TargetType.CLASS);
        }

        @NotNull
        public static Target<ClassNode> targetPreClass(String className) {
            return new Target<ClassNode>(className, "", "", TargetType.PRE_CLASS);
        }

        @NotNull
        public static Target<MethodNode> targetMethod(String className, String methodName, String methodDescriptor) {
            return new Target<MethodNode>(className, methodName, methodDescriptor, TargetType.METHOD);
        }

        @NotNull
        public static Target<FieldNode> targetField(String className, String fieldName) {
            return new Target<FieldNode>(className, fieldName, "", TargetType.FIELD);
        }

        public String getClassName() {
            return this.className;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getElementDescriptor() {
            return this.elementDescriptor;
        }

        public TargetType<T> getTargetType() {
            return this.targetType;
        }
    }
}

