/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.TargetType;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public final class TransformTargetLabel {
    private final Type className;
    private final String elementName;
    private final Type elementDescriptor;
    private final TargetType<?> labelType;

    TransformTargetLabel(ITransformer.Target<?> target) {
        this(target.getClassName(), target.getElementName(), target.getElementDescriptor(), target.getTargetType());
    }

    private TransformTargetLabel(String className, String elementName, String elementDescriptor, TargetType<?> labelType) {
        this.className = Type.getObjectType((String)className.replace('.', '/'));
        this.elementName = elementName;
        this.elementDescriptor = elementDescriptor.length() > 0 ? Type.getMethodType((String)elementDescriptor) : Type.VOID_TYPE;
        this.labelType = labelType;
    }

    public TransformTargetLabel(String className, String fieldName) {
        this(className, fieldName, "", TargetType.FIELD);
    }

    TransformTargetLabel(String className, String methodName, String methodDesc) {
        this(className, methodName, methodDesc, TargetType.METHOD);
    }

    @Deprecated
    public TransformTargetLabel(String className) {
        this(className, "", "", TargetType.CLASS);
    }

    public TransformTargetLabel(String className, TargetType<ClassNode> type) {
        this(className, "", "", type);
    }

    final Type getClassName() {
        return this.className;
    }

    public final String getElementName() {
        return this.elementName;
    }

    public final Type getElementDescriptor() {
        return this.elementDescriptor;
    }

    final TargetType<?> getTargetType() {
        return this.labelType;
    }

    public int hashCode() {
        return Objects.hash(this.className, this.elementName, this.elementDescriptor);
    }

    public boolean equals(Object obj) {
        try {
            TransformTargetLabel tl = (TransformTargetLabel)obj;
            return Objects.equals(this.className, tl.className) && Objects.equals(this.elementName, tl.elementName) && Objects.equals(this.elementDescriptor, tl.elementDescriptor);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public String toString() {
        return "Target : " + Objects.toString(this.labelType) + " {" + Objects.toString(this.className) + "} {" + Objects.toString(this.elementName) + "} {" + Objects.toString(this.elementDescriptor) + "}";
    }
}

