/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ServiceLoaderStreamUtils {
    public static <T> void parallelForEach(ServiceLoader<T> services, Consumer<T> consumer) {
        ServiceLoaderStreamUtils.forEach(services, consumer, true);
    }

    public static <T> void forEach(ServiceLoader<T> services, Consumer<T> consumer) {
        ServiceLoaderStreamUtils.forEach(services, consumer, false);
    }

    private static <T> void forEach(ServiceLoader<T> services, Consumer<T> consumer, boolean parallel) {
        StreamSupport.stream(services.spliterator(), parallel).forEach(consumer);
    }

    public static <T> List<T> toList(ServiceLoader<T> services) {
        return StreamSupport.stream(services.spliterator(), false).collect(Collectors.toList());
    }

    public static <K, T> Map<K, T> toMap(ServiceLoader<T> services, Function<T, K> keyFunction) {
        return ServiceLoaderStreamUtils.toMap(services, keyFunction, Function.identity());
    }

    public static <K, V, T> Map<K, V> toMap(ServiceLoader<T> services, Function<T, K> keyFunction, Function<T, V> valueFunction) {
        return StreamSupport.stream(services.spliterator(), false).collect(Collectors.toMap(keyFunction, valueFunction));
    }

    public static <T> ServiceLoader<T> errorHandlingServiceLoader(Class<T> clazz, Consumer<ServiceConfigurationError> errorHandler) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz);
        Iterator<T> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next();
            }
            catch (ServiceConfigurationError e) {
                errorHandler.accept(e);
            }
        }
        return serviceLoader;
    }
}

