/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ServiceLoaderStreamUtils;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformationServiceDecorator;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.TransformingClassLoaderBuilder;
import cpw.mods.modlauncher.api.ITransformationService;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

class TransformationServicesHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServiceLoader<ITransformationService> transformationServices = ServiceLoader.load(ITransformationService.class);
    private final Map<String, TransformationServiceDecorator> serviceLookup;
    private final TransformStore transformStore;

    TransformationServicesHandler(TransformStore transformStore) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Found transformer services : [{}]", new Supplier[]{() -> ServiceLoaderStreamUtils.toList(this.transformationServices).stream().map(ITransformationService::name).collect(Collectors.joining())});
        this.serviceLookup = StreamSupport.stream(this.transformationServices.spliterator(), false).collect(Collectors.toMap(ITransformationService::name, TransformationServiceDecorator::new));
        this.transformStore = transformStore;
    }

    void initializeTransformationServices(ArgumentHandler argumentHandler, Environment environment) {
        this.loadTransformationServices(environment);
        this.validateTransformationServices();
        this.processArguments(argumentHandler, environment);
        this.initialiseTransformationServices(environment);
        this.initialiseServiceTransformers();
    }

    TransformingClassLoader buildTransformingClassLoader(LaunchPluginHandler pluginHandler, TransformingClassLoaderBuilder builder) {
        return new TransformingClassLoader(this.transformStore, pluginHandler, builder);
    }

    private void processArguments(ArgumentHandler argumentHandler, Environment environment) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Configuring option handling for services");
        argumentHandler.processArguments(environment, this::computeArgumentsForServices, this::offerArgumentResultsToServices);
    }

    private void computeArgumentsForServices(OptionParser parser) {
        ServiceLoaderStreamUtils.parallelForEach(this.transformationServices, service -> service.arguments((a, b) -> parser.accepts(service.name() + "." + a, b)));
    }

    private void offerArgumentResultsToServices(OptionSet optionSet, BiFunction<String, OptionSet, ITransformationService.OptionResult> resultHandler) {
        ServiceLoaderStreamUtils.parallelForEach(this.transformationServices, service -> service.argumentValues((ITransformationService.OptionResult)resultHandler.apply(service.name(), optionSet)));
    }

    private void initialiseServiceTransformers() {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Transformation services loading transformers");
        this.serviceLookup.values().forEach(s -> s.gatherTransformers(this.transformStore));
    }

    private void initialiseTransformationServices(Environment environment) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Transformation services initializing");
        this.serviceLookup.values().forEach(s -> s.onInitialize(environment));
    }

    private void validateTransformationServices() throws RuntimeException {
        if (this.serviceLookup.values().stream().filter(d -> !d.isValid()).count() > 0L) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = this.serviceLookup.values().stream().filter(d -> !d.isValid())::count;
            LOGGER.error(LogMarkers.MODLAUNCHER, "Found {} services that failed to load", supplierArray);
            LOGGER.error(LogMarkers.MODLAUNCHER, "Failed services : {}", new Supplier[]{() -> this.serviceLookup.values().stream().filter(d -> !d.isValid()).map(TransformationServiceDecorator::getService).collect(Collectors.toList())});
            throw new RuntimeException("Invalid Service found");
        }
    }

    private void loadTransformationServices(Environment environment) {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Transformation services loading");
        this.serviceLookup.values().forEach(s -> s.onLoad(environment, this.serviceLookup.keySet()));
    }
}

