/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.NameMappingServiceDecorator;
import cpw.mods.modlauncher.ServiceLoaderStreamUtils;
import cpw.mods.modlauncher.api.INameMappingService;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

class NameMappingServiceHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServiceLoader<INameMappingService> namingServices = ServiceLoader.load(INameMappingService.class);
    private final Map<String, NameMappingServiceDecorator> namingLookup;

    public NameMappingServiceHandler() {
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Found naming services {}", new Supplier[]{() -> ServiceLoaderStreamUtils.toList(this.namingServices)});
        this.namingLookup = StreamSupport.stream(this.namingServices.spliterator(), false).collect(Collectors.toMap(INameMappingService::mappingName, NameMappingServiceDecorator::new));
    }
}

