/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ServiceLoaderStreamUtils;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class LaunchPluginHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, ILaunchPluginService> plugins;

    public LaunchPluginHandler() {
        ServiceLoader<ILaunchPluginService> services = ServiceLoader.load(ILaunchPluginService.class);
        this.plugins = ServiceLoaderStreamUtils.toMap(services, ILaunchPluginService::name);
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Found launch plugins: [{}]", new Supplier[]{() -> String.join((CharSequence)",", this.plugins.keySet())});
    }

    public Optional<ILaunchPluginService> get(String name) {
        return Optional.ofNullable(this.plugins.get(name));
    }

    public List<String> getPluginsTransforming(Type className, boolean isEmpty) {
        return this.plugins.entrySet().stream().filter(p -> ((ILaunchPluginService)p.getValue()).handlesClass(className, isEmpty)).peek(e -> LOGGER.debug(LogMarkers.LAUNCHPLUGIN, "LaunchPluginService {} wants to handle {}", e.getKey(), (Object)className)).collect(ArrayList::new, (l, e) -> l.add(e.getKey()), ArrayList::addAll);
    }

    public ClassNode offerClassNodeToPlugins(List<String> pluginNames, @Nullable ClassNode node, Type className) {
        ClassNode intermediate = node;
        for (String plugin : pluginNames) {
            ILaunchPluginService iLaunchPluginService = this.plugins.get(plugin);
            LOGGER.debug(LogMarkers.LAUNCHPLUGIN, "LauncherPluginService {} transforming {}", (Object)plugin, (Object)className);
            intermediate = iLaunchPluginService.processClass(intermediate, className);
        }
        return intermediate;
    }
}

