/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;

public class ArgumentHandler {
    private String[] args;
    private OptionSet optionSet;
    private OptionSpec<String> profileOption;
    private OptionSpec<Path> gameDirOption;
    private OptionSpec<Path> assetsDirOption;
    private OptionSpec<Path> minecraftJarOption;
    private OptionSpec<String> nonOption;
    private OptionSpec<String> launchTarget;

    void setArgs(String[] args) {
        this.args = args;
    }

    void processArguments(Environment env, Consumer<OptionParser> parserConsumer, BiConsumer<OptionSet, BiFunction<String, OptionSet, ITransformationService.OptionResult>> resultConsumer) {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        this.profileOption = parser.accepts("version", "The version we launched with").withRequiredArg();
        this.gameDirOption = parser.accepts("gameDir", "Alternative game directory").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.DIRECTORY_EXISTING}));
        this.assetsDirOption = parser.accepts("assetsDir", "Assets directory").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.DIRECTORY_EXISTING}));
        this.minecraftJarOption = parser.accepts("minecraftJar", "Path to minecraft jar").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[]{PathProperties.READABLE})).withValuesSeparatedBy(',');
        this.launchTarget = parser.accepts("launchTarget", "LauncherService target to launch").withRequiredArg();
        parserConsumer.accept(parser);
        this.nonOption = parser.nonOptions();
        this.optionSet = parser.parse(this.args);
        env.computePropertyIfAbsent(IEnvironment.Keys.VERSION.get(), s -> (String)this.optionSet.valueOf(this.profileOption));
        env.computePropertyIfAbsent(IEnvironment.Keys.GAMEDIR.get(), f -> (Path)this.optionSet.valueOf(this.gameDirOption));
        env.computePropertyIfAbsent(IEnvironment.Keys.ASSETSDIR.get(), f -> (Path)this.optionSet.valueOf(this.assetsDirOption));
        env.computePropertyIfAbsent(IEnvironment.Keys.LAUNCHTARGET.get(), f -> (String)this.optionSet.valueOf(this.launchTarget));
        resultConsumer.accept(this.optionSet, this::optionResults);
    }

    Path[] getSpecialJars() {
        return this.optionSet.valuesOf(this.minecraftJarOption).toArray(new Path[0]);
    }

    String getLaunchTarget() {
        return (String)this.optionSet.valueOf(this.launchTarget);
    }

    private ITransformationService.OptionResult optionResults(final String serviceName, final OptionSet set) {
        return new ITransformationService.OptionResult(){

            @Override
            @Nonnull
            public <V> V value(OptionSpec<V> option) {
                this.checkOwnership(option);
                return (V)set.valueOf(option);
            }

            @Override
            @Nonnull
            public <V> List<V> values(OptionSpec<V> option) {
                this.checkOwnership(option);
                return set.valuesOf(option);
            }

            private <V> void checkOwnership(OptionSpec<V> option) {
                if (!option.options().stream().allMatch(opt -> opt.startsWith(serviceName + ".") || !opt.contains("."))) {
                    throw new IllegalArgumentException("Cannot process non-arguments");
                }
            }
        };
    }

    public String[] buildArgumentList() {
        String[] ret = new String[this.args.length];
        System.arraycopy(this.args, 0, ret, 0, this.args.length);
        return ret;
    }
}

