/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.LaunchServiceHandlerDecorator;
import cpw.mods.modlauncher.Logging;
import cpw.mods.modlauncher.ServiceLoaderStreamUtils;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.util.Supplier;

class LaunchServiceHandler {
    private final ServiceLoader<ILaunchHandlerService> launchHandlerServices = ServiceLoader.load(ILaunchHandlerService.class);
    private final Map<String, LaunchServiceHandlerDecorator> launchHandlerLookup;

    public LaunchServiceHandler() {
        Logging.launcherLog.info("Found launch services [{}]", new Supplier[]{() -> ServiceLoaderStreamUtils.toList(this.launchHandlerServices).stream().map(ILaunchHandlerService::name).collect(Collectors.joining())});
        this.launchHandlerLookup = StreamSupport.stream(this.launchHandlerServices.spliterator(), false).collect(Collectors.toMap(ILaunchHandlerService::name, LaunchServiceHandlerDecorator::new));
    }

    private void launch(String target, String[] arguments, ClassLoader classLoader) {
        this.launchHandlerLookup.get(target).launch(arguments, classLoader);
    }

    public void launch(ArgumentHandler argumentHandler, TransformingClassLoader classLoader) {
        String launchTarget = argumentHandler.getLaunchTarget();
        String[] args = argumentHandler.buildArgumentList();
        this.launch(launchTarget, args, classLoader);
    }

    public Path[] identifyTransformationTargets(ArgumentHandler argumentHandler) {
        String launchTarget = argumentHandler.getLaunchTarget();
        Path[] transformationTargets = this.launchHandlerLookup.get(launchTarget).findTransformationTargets();
        Path[] specialJar = argumentHandler.getSpecialJars();
        return (Path[])Stream.concat(Arrays.stream(transformationTargets), Arrays.stream(specialJar)).toArray(Path[]::new);
    }
}

