/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.Logging;
import cpw.mods.modlauncher.ServiceLoaderStreamUtils;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.util.Supplier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class LaunchPluginHandler {
    private final Map<String, ILaunchPluginService> plugins;

    public LaunchPluginHandler() {
        ServiceLoader<ILaunchPluginService> services = ServiceLoader.load(ILaunchPluginService.class);
        this.plugins = ServiceLoaderStreamUtils.toMap(services, ILaunchPluginService::name);
        Logging.launcherLog.info("Found launch plugins: [{}]", new Supplier[]{() -> this.plugins.keySet().stream().collect(Collectors.joining())});
    }

    public Optional<ILaunchPluginService> get(String name) {
        return Optional.ofNullable(this.plugins.get(name));
    }

    public List<String> getPluginsTransforming(Type className) {
        return this.plugins.entrySet().stream().filter(p -> ((ILaunchPluginService)p.getValue()).handlesClass(className)).peek(e -> Logging.launcherLog.debug("LaunchPluginService {} wants to handle {}", e.getKey(), (Object)className)).collect(ArrayList::new, (l, e) -> l.add(e.getKey()), ArrayList::addAll);
    }

    public ClassNode offerClassNodeToPlugins(List<String> pluginNames, @Nullable ClassNode node, Type className) {
        ClassNode intermediate = node;
        for (String plugin : pluginNames) {
            ILaunchPluginService iLaunchPluginService = this.plugins.get(plugin);
            Logging.launcherLog.debug("LauncherPluginService {} transforming {}", (Object)plugin, (Object)className);
            intermediate = iLaunchPluginService.processClass(intermediate, className);
        }
        return intermediate;
    }
}

