/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.api.ILaunchHandlerService;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.concurrent.Callable;

public class DefaultLaunchHandlerService
implements ILaunchHandlerService {
    public static final String LAUNCH_PROPERTY = "minecraft.client.jar";
    public static final String LAUNCH_PATH_STRING = System.getProperty("minecraft.client.jar");

    @Override
    public String name() {
        return "minecraft";
    }

    @Override
    public Path[] identifyTransformationTargets() {
        if (LAUNCH_PATH_STRING == null) {
            throw new IllegalStateException("Missing minecraft.client.jar environment property. Update your launcher!");
        }
        return new Path[]{FileSystems.getDefault().getPath(LAUNCH_PATH_STRING, new String[0])};
    }

    @Override
    public Callable<Void> launchService(String[] arguments, ClassLoader launchClassLoader) {
        return () -> {
            Class<?> mcClass = Class.forName("net.minecraft.client.main.Main", true, launchClassLoader);
            Method mcClassMethod = mcClass.getMethod("main", String[].class);
            mcClassMethod.invoke(null, new Object[]{arguments});
            return null;
        };
    }
}

