/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.ClassTransformer;
import cpw.mods.modlauncher.Logging;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TransformingClassLoader
extends ClassLoader {
    private final ClassTransformer classTransformer;
    private final DelegatedClassLoader delegatedClassLoader;
    private final URL[] specialJars;

    public TransformingClassLoader(TransformStore transformStore, File ... specialJars) {
        this.classTransformer = new ClassTransformer(transformStore);
        this.specialJars = Stream.of(specialJars).map(LamdbaExceptionUtils.rethrowFunction(f -> f.toURI().toURL())).collect(Collectors.toList()).toArray(new URL[specialJars.length]);
        this.delegatedClassLoader = new DelegatedClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz;
            try {
                Logging.launcherLog.debug(Logging.CLASSLOADING, "Loading {}", (Object)name);
                clazz = this.delegatedClassLoader.findClass(name);
            }
            catch (ClassNotFoundException | SecurityException e) {
                Class<?> clazz2;
                try {
                    clazz2 = super.loadClass(name, resolve);
                }
                catch (Throwable throwable) {
                    Logging.launcherLog.debug(Logging.CLASSLOADING, "Loaded {}", (Object)name);
                    throw throwable;
                }
                Logging.launcherLog.debug(Logging.CLASSLOADING, "Loaded {}", (Object)name);
                return clazz2;
            }
            Logging.launcherLog.debug(Logging.CLASSLOADING, "Loaded {}", (Object)name);
            return clazz;
        }
    }

    public <T> Class<T> getClass(String name, byte[] bytes) {
        return super.defineClass(name, bytes, 0, bytes.length);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private class DelegatedClassLoader
    extends URLClassLoader {
        DelegatedClassLoader() {
            super(TransformingClassLoader.this.specialJars);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return TransformingClassLoader.this.loadClass(name, resolve);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] classBytes;
            URL classResource;
            block18: {
                Class<?> existingClass = super.findLoadedClass(name);
                if (existingClass != null) {
                    Logging.launcherLog.debug(Logging.CLASSLOADING, "Found existing class {}", (Object)name);
                    return existingClass;
                }
                String path = name.replace('.', '/').concat(".class");
                classResource = this.findResource(path);
                if (classResource != null) {
                    try (AutoURLConnection urlConnection = new AutoURLConnection(classResource);){
                        int read;
                        int length = urlConnection.getContentLength();
                        InputStream is = urlConnection.getInputStream();
                        classBytes = new byte[length];
                        int pos = 0;
                        for (int remain = length; (read = is.read(classBytes, pos, remain)) != -1 && remain > 0; remain -= read) {
                            pos += read;
                        }
                        break block18;
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException("blargh", e);
                    }
                }
                classBytes = new byte[]{};
            }
            if ((classBytes = TransformingClassLoader.this.classTransformer.transform(classBytes, name)).length > 0) {
                Logging.launcherLog.debug(Logging.CLASSLOADING, "Loaded transform target {} from {}", (Object)name, (Object)classResource);
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
            Logging.launcherLog.debug(Logging.CLASSLOADING, "Failed to transform target {} from {}", (Object)name, (Object)classResource);
            throw new ClassNotFoundException();
        }
    }

    static class AutoURLConnection
    implements AutoCloseable {
        private final URLConnection urlConnection;
        private final InputStream inputStream;

        AutoURLConnection(URL url) throws IOException {
            this.urlConnection = url.openConnection();
            this.inputStream = this.urlConnection.getInputStream();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        int getContentLength() {
            return this.urlConnection.getContentLength();
        }

        InputStream getInputStream() {
            return this.inputStream;
        }
    }
}

