/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.Logging;
import cpw.mods.modlauncher.ServiceLoaderStreamUtils;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Supplier;

public class LaunchPluginHandler {
    private final Map<String, ILaunchPluginService> plugins;

    LaunchPluginHandler() {
        ServiceLoader<ILaunchPluginService> services = ServiceLoader.load(ILaunchPluginService.class);
        this.plugins = ServiceLoaderStreamUtils.toMap(services, ILaunchPluginService::name);
        Logging.launcherLog.info("Found launch plugins: [{}]", new Supplier[]{() -> this.plugins.keySet().stream().collect(Collectors.joining())});
    }

    public Optional<ILaunchPluginService> get(String name) {
        return Optional.ofNullable(this.plugins.get(name));
    }
}

