/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformerVote;
import cpw.mods.modlauncher.VoteDeadlockException;
import cpw.mods.modlauncher.VoteRejectedException;
import cpw.mods.modlauncher.VotingContext;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassTransformer {
    private static final byte[] EMPTY = new byte[0];
    private final TransformStore transformers;

    ClassTransformer(TransformStore transformers) {
        this.transformers = transformers;
    }

    byte[] transform(byte[] inputClass, String className) {
        boolean empty;
        byte[] digest;
        Type classDesc = Type.getObjectType((String)className.replaceAll("\\.", "/"));
        if (!this.transformers.needsTransforming(className)) {
            return inputClass;
        }
        ClassNode clazz = new ClassNode(327680);
        if (inputClass.length > 0) {
            ClassReader classReader = new ClassReader(inputClass);
            classReader.accept((ClassVisitor)clazz, 0);
            digest = this.getSha256().digest(inputClass);
            empty = false;
        } else {
            clazz.name = classDesc.getInternalName();
            clazz.version = 52;
            clazz.superName = "java/lang/Object";
            digest = this.getSha256().digest(EMPTY);
            empty = true;
        }
        VotingContext context = new VotingContext(className, empty, digest);
        ArrayList<Object> fieldList = new ArrayList<Object>(clazz.fields.size());
        for (Object field : clazz.fields) {
            ArrayList fieldTransformers = new ArrayList(this.transformers.getTransformersFor(className, (FieldNode)field));
            fieldList.add(this.performVote(fieldTransformers, field, context));
        }
        ArrayList<MethodNode> methodList = new ArrayList<MethodNode>(clazz.methods.size());
        for (MethodNode method : clazz.methods) {
            ArrayList methodTransformers = new ArrayList(this.transformers.getTransformersFor(className, method));
            methodList.add(this.performVote(methodTransformers, method, context));
        }
        clazz.fields = fieldList;
        clazz.methods = methodList;
        ArrayList classTransformers = new ArrayList(this.transformers.getTransformersFor(className));
        clazz = this.performVote(classTransformers, clazz, context);
        ClassWriter cw = new ClassWriter(327680);
        clazz.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private <T> T performVote(List<ITransformer<T>> transformers, T node, VotingContext context) {
        do {
            Stream<TransformerVote> voteResultStream;
            Map<TransformerVoteResult, List<TransformerVote>> results;
            if ((results = (voteResultStream = transformers.stream().map(t -> this.gatherVote((ITransformer)t, context))).collect(Collectors.groupingBy(TransformerVote::getResult))).containsKey((Object)TransformerVoteResult.REJECT)) {
                throw new VoteRejectedException(results.get((Object)TransformerVoteResult.REJECT), node.getClass());
            }
            if (results.containsKey((Object)TransformerVoteResult.NO)) {
                transformers.removeAll(results.get((Object)TransformerVoteResult.NO).stream().map(TransformerVote::getTransformer).collect(Collectors.toList()));
            }
            if (results.containsKey((Object)TransformerVoteResult.YES)) {
                ITransformer<T> transformer = results.get((Object)TransformerVoteResult.YES).get(0).getTransformer();
                node = transformer.transform(node, context);
                transformers.remove(transformer);
                continue;
            }
            if (!results.containsKey((Object)TransformerVoteResult.DEFER)) continue;
            throw new VoteDeadlockException(results.get((Object)TransformerVoteResult.DEFER), node.getClass());
        } while (!transformers.isEmpty());
        return node;
    }

    private <T> TransformerVote<T> gatherVote(ITransformer<T> transformer, VotingContext context) {
        TransformerVoteResult vr = transformer.castVote(context);
        return new TransformerVote<T>(vr, transformer);
    }

    private MessageDigest getSha256() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("HUH");
        }
    }
}

